#include "mbed.h"
#include "MMA8451Q.h" 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

Serial pc(USBTX, USBRX);
 
int main(void) {
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut crvena(LED1);
    PwmOut zelena(LED2);
    PwmOut plava(LED3); 
    while (true) {
        float x, y, z;
        crvena = 1.0 - abs(acc.getAccX());
        zelena = 1.0 - abs(acc.getAccY());
        plava = 1.0 - abs(acc.getAccZ());
        pc.printf("Akceleracija po x osi : %.2f   Akceleracija po y-osi : %.2f   Akceleracija po z-osi : %.2f \n", acc.getAccX(),acc.getAccY(),acc.getAccZ());
        wait(2);
    }
}