#include "mbed.h"
#include "N5110.h"

#define razmakX 83.0
#define razmakY 47.0

AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
InterruptIn taster1(dp1);

int brojac_tacki(0);
int tacka1x, tacka1y, tacka2x, tacka2y;

int centar_crosshairx(0);
int centar_crosshairy(0);






N5110 display(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

Timer db; //za debouncing

Timer dvoklik;


void draw_crosshair(int x, int y)
{

    for(int i = centar_crosshairx-3;i<centar_crosshairx+4;i++)
        
        if(i==tacka1x && centar_crosshairy == tacka1y || i==tacka2x && centar_crosshairy == tacka2y) {}
        else
            display.clearPixel(i, centar_crosshairy);
        
    for(int i=centar_crosshairy-3;i<centar_crosshairy+4;i++)
        
        if(centar_crosshairx==tacka1x && i == tacka1y || centar_crosshairx==tacka2x && i == tacka2y){}
        else
            display.clearPixel(centar_crosshairx, i);
    
    centar_crosshairx = x;
    centar_crosshairy = y;
    

    for(int i = x-3;i<x+4;i++)
        if(i >=0 && i <=83)
        {
             display.setXYAddress(0,0);
            display.setPixel(i, y);
             
            display.refresh();
            
        }
        
    for(int i=y-3;i<y+4;i++)
        if(i >=0 && i <=47)
        {
            display.setXYAddress(0,0);
            display.setPixel(x, i);
            
            display.refresh();
        }
}

void crtajPravougaonik()
{
    __disable_irq(); 
    int i, j, grx, gry;
    if(tacka1x < tacka2x)
    {   i = tacka1x;
        grx = tacka2x;
    
    }
    else
        
        {
            i = tacka2x;
            grx = tacka1x;
            
        }
    
    if(tacka1y < tacka2y)
{
    j = tacka1y;
    gry = tacka2y;
    
    }
    else
{
    j = tacka2y;
    gry = tacka1y;
    
    }
    
    int j2 = j;
    
    while(i < grx)
    {
        while(j < gry)
        {
            
            display.setXYAddress(0,0);        
            display.setPixel(i, j);
            display.refresh();
            j++;
        }
        
        j = j2;
        i++;
        
    }
            
__enable_irq();

}

void tacka()
{
    
    
    
    if(db.read_ms() <= 200) return;
    
    
    
    if(dvoklik.read_ms() < 1000)
    {
        display.clear();
        return;
    }
    
    
    
    
    
 
    
    display.setXYAddress(0,0);
    display.setPixel(centar_crosshairx, centar_crosshairy);
    
    display.refresh();
    brojac_tacki++;
    
    if(brojac_tacki==1)
    {
        tacka1x = centar_crosshairx;
        tacka1y = centar_crosshairy;
    
    }

    else if(brojac_tacki==2)
    {
        tacka2x = centar_crosshairx;
        tacka2y = centar_crosshairy;
        crtajPravougaonik();
        brojac_tacki = 0;
    }
    
    
    db.reset();
    dvoklik.reset();

}



int main()

{
        db.start();
        dvoklik.start();
        display.init();
        display.normalMode();
        display.setXYAddress(0,0);
        
        taster1.rise(&tacka);
        
        while(1)
        {
            draw_crosshair(VRx.read()*razmakX, VRy.read()*razmakY);
            
        }

}
