#include "mbed.h"

#include <cmath>

#define EYE_WAIT_TIME 10 // microseconds
#define DEBOUNCE_TIME 100

#define HIGH 1 // xD
#define LOW 0

int counter = 0;

BusOut segments(dp2, dp1, dp28, dp6, dp5, dp27, dp26);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp4);

BusIn columns(dp9,dp10,dp11,dp13);
BusOut rows(dp16, dp15, dp17, dp18);

int digit_buffer[3] = {1, 2, 3};
unsigned int predefined_segments[19] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 
                                0x24, 0x20, 0x0f, 0x00, 0x04,
                                0x08,0x60,0x31,0x42,0x30,0x38,
                                ~(0x01), 0x36, ~0};
                            
int pressed_button() {
    
    if(counter > 5) {
        counter = 0;    
    } else {
        counter++;
        return -1;  
    }
    
    int lookup[] = {1, 2, 3, 10, 4, 5, 6, 11, 
                    7, 8, 9, 12, 16, 0, 17, 13};

    for(int i = 0; i <= 3; i++) {
        rows = (1 << i); // probe a row 
        for(int j = 0; j <= 3; j++)
            if(columns == (1 << j))
                return lookup[ i * 4 + j ];
    }

    return -1;
}

void display_digit_buffer() {
    if(digit_buffer[2] == 12) {
        digit_buffer[0] = 18;
        digit_buffer[1] = 18;
        digit_buffer[2] = 18;
    }
    for(int i = 1; i <= 4; i = i * 2) { // ne moze *=
        digit = ~i;
        segments = predefined_segments[ digit_buffer[i / 2] ];
        decimal_point = 1;
        wait_ms(EYE_WAIT_TIME);
    }
}

void buffer(int button) {
    if(button == -1) return;
    
    for(int i = 0; i <= 1; i++)
        digit_buffer[i] = digit_buffer[i + 1];
    
    digit_buffer[2] = button;
}

int main() {
    
    while(true) {
        buffer(pressed_button());
        display_digit_buffer();
        //wait_ms(50);
    }

    return 0;
}