#include "mbed.h"

#define EPS 1e-4 // for float comparison

using namespace std;

//BusOut segments(dp26, dp27, dp5, dp6, 
               // dp28, dp1, dp2); //per digit, ABCDEFG
                
BusOut segments(dp2, dp1, dp28, dp6, dp5, dp27, dp26);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp4);

Timer timer;

int predefined_segments[10] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 
                                0x24, 0x20, 0x0f, 0x00, 0x04};
int chars[6] = {0x08,0x60,0x31,0x42,0x30,0x38}; // Adnan Muslija je zvjer

void display(float current_timer) {
    int timer_digits[3] = { (int)(current_timer / 10.) % 10, 
                            (int)(current_timer) % 10, 
                            (int)(current_timer * 10.) % 10 };

    for(int i = 1; i <= 4; i = i * 2) { // ne moze *=
        digit = ~i;
        segments = predefined_segments[ timer_digits[i / 2] ];
        decimal_point = (i == 2) ? 0 : 1;
        wait_ms(1);
    }
    
    
}

int main() {
    
    //wait(2.);
    timer.start();

    // assume loop cycle is faster than .1 sec
    // ako NITI TNAO
    while(timer.read() < 10.) {
        display(timer.read());
    }
    
    display(10.0);
    
    return 0;
}