#include "mbed.h"

using namespace std;

BusOut segments(dp18, dp4, dp28, dp6, dp5, dp27, dp26);
InterruptIn taster1(dp1);
InterruptIn taster2(dp2);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp17);

Timer timer;
Timer debounce1;
Timer debounce2;
Ticker osvjezi_tiker;

int red_br_cifre;
int cifra_za_ispis;
int prva_cifra, druga_cifra, treca_cifra;
int predefined_segments[10] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 0x24, 0x20, 0x0f, 0x00, 0x04};
int chars[6] = {0x08,0x60,0x31,0x42,0x30,0x38};

void osvjezi()
{
    red_br_cifre=3;//prva cifra
    cifra_za_ispis=predefined_segments[prva_cifra];

    red_br_cifre=5;//druga cifra
    cifra_za_ispis=predefined_segments[druga_cifra];

    red_br_cifre=6;//treca cifra
    cifra_za_ispis=predefined_segments[treca_cifra];
}

void display(float current_timer)
{
    int timer_digits[3] = { (int)(current_timer / 10.) % 10,
                            (int)(current_timer) % 10,
                            (int)(current_timer * 10.) % 10
                          };

    for(int i = 1; i <= 4; i = i * 2) {
        digit = ~i;
        segments = predefined_segments[ timer_digits[i / 2] ];
        decimal_point = (i == 2) ? 0 : 1;
        osvjezi_tiker.attach_us(&osvjezi, 1000);
    }
}

bool stopiran = true;

void start()
{
    if(debounce1.read_ms() > 200) {
        if(stopiran) {
            timer.start();
            stopiran = false;
        } else {
            timer.stop();
            stopiran = true;
        }
        debounce1.reset();
    }

}

void reset()
{
    if(debounce2.read_ms() > 200) {
        timer.reset();
        timer.stop();
        stopiran = true;
        display(0.00);
        debounce2.reset();
    }
}


int main()
{
    debounce1.start();
    debounce2.start();
    taster1.rise(&start);
    taster2.rise(&reset);
    while(1) {
        display(timer.read());
    }
}