#include <vector>
#include <cmath>

#include "mbed.h"

#define STEP_SIZE 50 // in ms
#define STEP_HEIGHT 1/10.
#define PI 3.14

AnalogOut osciloscope(PTE30);

int main() {

    // initialize steps
    vector<float> steps;

    float current = 1.;
    while(current >= 0.) {
        steps.push_back(current);
        current -= STEP_HEIGHT; 
    }
    while(current <= 1.) {
        steps.push_back(current);
        current += STEP_HEIGHT;
    }

    int current_step = 0;
    while(true) {
        osciloscope = steps[current_step++ % steps.size()] / 3.3;
        //osciloscope = 1.;
        wait_us(STEP_SIZE);
    }

    return 0; // redundant
}