#include "mbed.h"
#include "cmath"
#include "string"
 
 //tastatura
DigitalIn kolone[4]={dp9, dp10, dp11, dp13};
DigitalOut redovi[4]={dp16, dp15, dp17, dp18};
//            .      G       F    E      D      C      B     A
BusOut ekran(dp26,dp27,dp5,dp6,dp28, dp1, dp2, dp4);
//           D2     D3     D4
BusOut cifre(dp23, dp24, dp25);
DigitalOut enable(dp14);
DigitalOut taster1(dp1);  // taster jedan
DigitalOut taster2(dp2);   // taster dva
// Na 0 se ukljucuju ledice
//                0       1      ...
int brojevi[10]= {0x40, 0xf9, 0x24, 0x30, 0x19, 0x12, 0x02, 0xf8, 0x00, 0x10};
 
char br[] = {'0','0','0'};
char op=' ';
int memori=0;


void taster(){
    int brojac=0;
    op = 'X';
    while(brojac<2 || op != 'X'){
    for(int i=0; i<4; i++){   
        redovi[i]=1;
        if(i==0){
            if(kolone[0]==1) br[brojac]='1';
            if(kolone[1]==1) br[brojac]='2';
            if(kolone[2]==1) br[brojac]='3';
            if(kolone[3]==1) op='+';
        }
        else if(i==1){
            if(kolone[0]==1) br[brojac]='4';
            if(kolone[1]==1) br[brojac]='5';
            if(kolone[2]==1) br[brojac]='6';
            if(kolone[3]==1) op='-';
        }
        else if(i==2){
            if(kolone[0]==1) br[brojac]='7'; 
            if(kolone[1]==1) br[brojac]='8';
            if(kolone[2]==1) br[brojac]='9';
            if(kolone[3]==1) op='/';
        }
        else if(i==3){
            if(kolone[0]==1) op='=';
            if(kolone[1]==1) br[brojac]='0';
            if(kolone[2]==1) op=',';
            if(kolone[3]==1) op='*';
        }  
    
       redovi[i]=0;  
    }
    brojac++;
    }

}   

char taster2nd(){
    int brojac=0;
    op = 'X';
    while(brojac<2 || op != 'X'){
    for(int i=0; i<4; i++){   
        redovi[i]=1;
        if(i==0){
            if(kolone[0]==1) br[brojac]='1';
            if(kolone[1]==1) br[brojac]='2';
            if(kolone[2]==1) br[brojac]='3';
            if(kolone[3]==1) op = 'S';
        }
        else if(i==1){
            if(kolone[0]==1) br[brojac]='4';
            if(kolone[1]==1) br[brojac]='5';
            if(kolone[2]==1) br[brojac]='6';
            if(kolone[3]==1) op='>';
        }
        else if(i==2){
            if(kolone[0]==1) br[brojac]='7'; 
            if(kolone[1]==1) br[brojac]='8';
            if(kolone[2]==1) br[brojac]='9';
            if(kolone[3]==1) op='<';
        }
        else if(i==3){
            if(kolone[0]==1) op='=';
            if(kolone[1]==1) br[brojac]='0';
            if(kolone[2]==1) op='C';
            if(kolone[3]==1) op='P';
        }  
    
       redovi[i]=0;  
    }
    brojac++;
    }
}

char taster3rd(){
    int brojac=0;
    op = 'X';
    while(brojac<2 || op != 'X'){
    for(int i=0; i<4; i++){   
        redovi[i]=1;
        if(i==0){
            if(kolone[0]==1) br[brojac]='1';
            if(kolone[1]==1) br[brojac]='2';
            if(kolone[2]==1) br[brojac]='3';
            if(kolone[3]==1) op = 'B';
        }
        else if(i==1){
            if(kolone[0]==1) br[brojac]='4';
            if(kolone[1]==1) br[brojac]='5';
            if(kolone[2]==1) br[brojac]='6';
            if(kolone[3]==1) op = 'D';
        }
        else if(i==2){
            if(kolone[0]==1) br[brojac]='7'; 
            if(kolone[1]==1) br[brojac]='8';
            if(kolone[2]==1) br[brojac]='9';
            if(kolone[3]==1) op = 'L';
        }
        else if(i==3){
            if(kolone[0]==1) op='=';
            if(kolone[1]==1) br[brojac]='0';
            if(kolone[3]==1) op = 'I';
        if(kolone[2]==1) op = 'T';
        }  
    
       redovi[i]=0;  
    }
    brojac++;
    }
}

int BinToDec(int broj[]){
    int sum=0;
    int vel = sizeof(broj)/sizeof(int);
    for(int i =0; i<vel; i++){
    sum = sum+ pow((float)2,i);
    }
    return sum;
}

int dec_to_bin[2];

void DecToBin (int broj){
    int i=0;
    while(broj>0 && broj<8){
        if(broj%2 == 0)
        dec_to_bin[i] = 0;
        else dec_to_bin[i] = 1;
        i++;
        broj = broj/2;
    }
    
}



void show(char znak[]);
void operacija(char znak){
    int k = 0;
    int i = br[0] - '0' + (br[1] - '0')*10 + (br[2] - '0')*100;
    char slijedeci[3];
    if(znak=='S' || znak=='<' || znak=='>' || znak=='C' || znak=='P')  taster2nd();
    else if(znak=='B' || znak=='D' || znak=='L' || znak=='I' || znak=='T')  taster3rd(); 
    else taster();
    for(int i=0; i<3; i++) slijedeci[i] = br[i];
    int j = slijedeci[0] - '0' + (slijedeci[1] - '0')*10 + (slijedeci[2] - '0')*100;
    
    if(znak == '+') {
        k = i+j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    if(znak == '-'){
        k = i-j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    if(znak == '/') {
        k = (float)i/j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    if(znak == '*'){
        k = i*j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    if(znak == ','){
        k = i;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = '.';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    
    //2nd operacije : korjen, spasi u memoriju, dobavi iz memorije, x na y, clear
    if(znak == 'S'){
        k = sqrt(float(i));
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }   //              korjen
    if(znak == 'C') {
        slijedeci[0] = ' ';
        slijedeci[1] = ' ';
        slijedeci[2] = '0';
        }  //                                    clear
    if(znak == '>'){
        memori = i;
        }  //                             -> M tj. upis u memoriju
    if(znak == '<'){
        k = memori;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }              //                <- M  tj. upis iz memorije
    if(znak == 'P'){
        k = pow((float)i,j);
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }  //           x^y
    
    //3rd operacije: BinToDec, DecToBin, Ln, 1/x, sin
    if(znak == 'B'){
        k = i*j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }  //              Binarni u dekadni
    if(znak == 'D'){{
        k = i*j;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } //                                    Dekadni u binarni
    if(znak == 'L'){
        k = log10(float(i));
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }  //             ln(x)
    if(znak == 'I') {
        k = 1/float(i);
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }  //                   1/x
    if(znak == 'T') {
        k = sin(float(i));
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        }  //                 sin(x)
    
    if(znak == '='){
        k = i;
        slijedeci[0] = k%100 + '0';
        k/=100;
        slijedeci[1] = k%10 + '0';
        k/=10;
        slijedeci[2] = k + '0';
        } 
    show(slijedeci);   
} 
}   

void show(char znak[]){
    for(int i=0; i<3; i++){
        
    if(znak[i]>='0' &&  znak[i]<='9')
    {
         ekran = brojevi[znak[i] - '0'];
    }
    
    else
    {
       operacija(znak[i]);       
       
    }
    }
   
}

 
int main() {
    enable = 1;
    int t1=1, t2=1;
    char pom[2];
    
    while(1) {
    if(taster1){
        if(t1==1) t1=0;
        else t1=1;
    }
    if(taster2){
        if(t1==1) t1=0;
        else t1=1;
    }
    if((t1==0 && t2==0) || t1==0) taster2nd();
    else if(t2==0) taster3rd();
    else  taster();
    for(int i = 0; i<3; i++) pom[i] = br[i];
    show(pom);        
    }
}
