#include "mbed.h"
#include "Serial.h"
#include "N5110.h"

Serial pc(USBTX, USBRX);
N5110 displej(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

AnalogIn VRx(dp11);
AnalogIn VRy(dp10);

DigitalIn taster1(dp1);
//DigitalIn taster2(dp2);

DigitalIn SW(dp9);

int detektirajPozadinu(int x, int y)
{/*
    if(x>83 || x<0 || y>47 || y<0) return 'x';
    int brRubnih(0), brCrnih(0);
    unsigned char gore,dole,lijevo,desno;
    if(x == 0) lijevo = 'x';
    else lijevo = displej.getPixel(x-1,y);
    if(x == 83) desno = 'x';
    else desno = displej.getPixel(x+1,y);
    if(y == 0) dole = 'x';
    else dole = displej.getPixel(x,y-1);
    if(y == 47) gore = 'x';
    else gore = displej.getPixel(x,y+1);
    if(lijevo == '0') brCrnih++;
    else if(lijevo == 'x') brRubnih++;
    if(desno == '0') brCrnih++;
    else if(desno == 'x') brRubnih++;
    if(gore == '0') brCrnih++;
    else if(gore == 'x') brRubnih++;
    if(dole == '0') brCrnih++;
    else if(dole == 'x') brRubnih++;
    int brBijelih(4-brCrnih-brRubnih);
    if(brBijelih < brCrnih) return 'c';
    return 'b';*/
    
    if(x>83 || x<0 || y<0 || y>47) return -1;
    int gore,dole,desno,lijevo;

    if(x == 0) lijevo = -1;
    else {
        lijevo = displej.getPixel(x-1,y);
        if(lijevo != 0) lijevo=1;
    }
    if(x == 83) desno = -1;
    else {
        desno = displej.getPixel(x+1,y);
        if(desno !=0) desno=1;
    }
    if(y == 0) dole = -1;
    else {
        dole = displej.getPixel(x,y-1);
        if(dole!=0) dole=1;
    }
    if(y == 47) gore = -1;
    else {
        gore = displej.getPixel(x,y+1);
        if(gore!=0) gore=1;
    }
    int okolo[4]={gore,dole,lijevo,desno};
    int clear(0),set(0),rub(0);
    for(int i=0;i<4;i++) {
        if(okolo[i]==1) set++;
        if(okolo[i]==0) clear++;
        if(okolo[i]==-1) rub++;
    }
    if(set>clear) return 1;
    if(clear>set) return 0;
    return -1;
}

void postaviKursor(int x, int y)
{
    /*for(int i(1); i<5; i++) {
        char pozadina(detektirajPozadinu(x+i, y));
        if(pozadina == 'b')
            displej.setPixel(x+i,y);
        else if(pozadina == 'c') displej.clearPixel(x+i,y);
        pozadina=detektirajPozadinu(x, y+i);
        if(pozadina == 'b')
            displej.setPixel(x,y+i);
        else if(pozadina == 'c') displej.clearPixel(x,y+i);
        pozadina=detektirajPozadinu(x-i, y);
        if(pozadina == 'b')
            displej.setPixel(x-i,y);
        else if(pozadina == 'c') displej.clearPixel(x-i,y);
        pozadina=detektirajPozadinu(x, y-i);
        if(pozadina == 'b')
            displej.setPixel(x,y-i);
        else if(pozadina == 'c') displej.clearPixel(x,y-i);
    }*/
    displej.setPixel(x,y);
    wait(0.01);
}

int main()
{
    SW.mode(PullUp);
    displej.init();
    displej.setXYAddress(0,0);
    int x(0),y(0);
    pc.baud(115200);
    for(int i=0; i<84; i++) {
        for(int j=0; j<48; j++) {
            if(pc.getc()=='1') {
                displej.setXYAddress(0,0);
                displej.setPixel(i,j);
            }
        }
    }
    while(1) {
        if(VRx<1.0/3.0) {
            if (x>0) {
                x--;
            }
        }

        else if (VRx>2.0/3.0) {
            if(x<83) {
                x++;
            }
        }

        if (VRy<1.0/3.0) {
            if(y>0) {
                y--;
            }
        }

        else if (VRy>2.0/3.0) {
            if(y<47) {
                y++;
            }
        }

        //saranje
        postaviKursor(x,y);
        if(taster1==1) {
            if(displej.getPixel(x,y) == '0')
                displej.setPixel(x,y);
            else displej.clearPixel(x,y);
        }

        //prenos na racunar
        if(pc.readable() == 1) {
            if(pc.getc() == 'x') {
                for(int i=0; i<84; i++) {
                    for(int j=0; j<48; j++) {
                        displej.setXYAddress(0,0);
                        if(displej.getPixel(i, j) == 0)
                            pc.putc('0');
                        else if (displej.getPixel(i, j)==1) pc.putc('1');
                        else pc.putc('1');
                    }
                }
                pc.putc('\n');
            }
        }
        displej.refresh();
    }

}