#include "mbed.h"
#include "N5110.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#include <string>

#define MMA8451_I2C_ADDRESS (0x1d<<1)

//Deklaracija akcelerometra
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd (PTA5, PTA12, PTD4, PTA4, PTC6, PTC5, PTC8);

//Deklaracija globalnih varijabli
int staroX(10);
int staroY(10);
int novoX(10);
int novoY(10);

int duzinaPutaXPoz(0);
int duzinaPutaYPoz(0);
int duzinaPutaXNeg(0);
int duzinaPutaYNeg(0);


TSISensor tsi;
Timer sat;
bool pocetakIgre(true);
bool krajIgre(false);
bool labirint[84][48];
float brzina(0.1);

//Crtanje labirinta i punjenje matrice (obavlja se pocetku svake igre)

void postaviRupu()
{
    lcd.setXYAddress(0,0);
    lcd.setPixel(57, 24);
    lcd.setPixel(56, 24);
    lcd.setPixel(58, 24);
    lcd.setPixel(59, 24);
    lcd.setPixel(57, 25);
    lcd.setPixel(58, 25);
    lcd.setPixel(57, 23);
    lcd.setPixel(56, 23);
    lcd.setPixel(58, 23);
    lcd.setPixel(59, 23);
    lcd.setPixel(57, 22);
    lcd.setPixel(58, 22);
    
    lcd.refresh();
}

void inicijalizirajLabirint()
{
    //"Ciscenje" matrice:
    for(int i = 0; i < 84; i++)
        for(int j = 0; j < 48; j++)
            labirint[i][j] = 0;
    //Vanjske granice:
    for(int i = 0; i < 84; i++)
    {
        lcd.setPixel(i,0);
        labirint[i][0] = 1;
    }
    for(int i = 0; i < 84; i++)
    {
        lcd.setPixel(i, 47);
        labirint[i][47] = 1;
    }
    for(int i = 0; i < 48; i++)
    {
        lcd.setPixel(0, i);
        labirint[0][i] = 1;
    }
    for(int i = 0; i < 48; i++)
    {
        lcd.setPixel(83, i);
        labirint[83][i] = 1;
    }
    //Prvi unutrasnji zidovi:
    for(int i = 7; i < 77; i++)
    {
        lcd.setPixel(i,7);
        labirint[i][7] = 1;
    }
    for(int i = 7; i < 77; i++)
    {
        lcd.setPixel(i, 40);
        labirint[i][40] = 1;
    }
    for(int i = 7; i < 40; i++)
    {
        lcd.setPixel(7, i);
        labirint[7][i] = 1;
    }
    for(int i = 7; i < 40; i++)
    {
        lcd.setPixel(76, i);
        labirint[76][i] = 1;
    }
    //Prolazi za prve unutrasnje zidove:
    for(int i = 11; i < 17; i++)
    {
        lcd.clearPixel(76, i);
        labirint[76][i] = 0;
    }
    for(int i = 54; i < 60; i++)
    {
        lcd.clearPixel(i, 40);
        labirint[i][40] = 0;
    }
    //Drugi unutrasnji zidovi:
    for(int i = 14; i < 70; i++)
    {
        lcd.setPixel(i, 14);
        labirint[i][14] = 1;
    }
    for(int i = 14; i < 70; i++)
    {
        lcd.setPixel(i, 33);
        labirint[i][33] = 1;
    }
    for(int i = 14; i < 34; i++)
    {
        lcd.setPixel(14, i);
        labirint[14][i] = 1;
    }
    for(int i = 14; i < 34; i++)
    {
        lcd.setPixel(69, i);
        labirint[69][i] = 1;
    }
    //Prolazi za druge unutrasnje zidove:
    for(int i = 18; i < 25; i++)
    {
        lcd.clearPixel(i, 14);
        labirint[i][14] = 0;
    }
    for(int i = 18; i < 25; i++)
    {
        lcd.clearPixel(69, i);
        labirint[69][i] = 0;
    }
    //Spoj izmedju prvih i drugih unutrasnjih zidova:
    for(int i = 8; i < 14; i++)
    {
        lcd.setPixel(i, 24);
        labirint[i][24] = 1;
    }
    //Treci unutrasnji zidovi:
    for(int i = 21; i < 63; i++)
    {
        lcd.setPixel(i, 21);
        labirint[i][21] = 1;
    }
    for(int i = 21; i < 63; i++)
    {
        lcd.setPixel(i, 26);
        labirint[i][26] = 1;
    }
    for(int i = 21; i < 27; i++)
    {
        lcd.setPixel(21, i);
        labirint[21][i] = 1;
    }
    for(int i = 21; i < 27; i++)
    {
        lcd.setPixel(62, i);
        labirint[62][i] = 1;
    }
    //Prolaz za trece unutrasnje zidove
    for(int i = 25; i < 31; i++)
    {
        lcd.clearPixel(i, 26);
        labirint[i][26] = 0;
    }
    //Spoj izmedju drugih i trecih unutrasnjih zidova:
    for(int i = 27; i < 34; i++)
    {
        lcd.setPixel(48, i);
        labirint[48][i] = 1;
    }
    lcd.refresh();
    //Rupa:
    postaviRupu();
    
    
}
 

//Citanje vrijednosti sa akcelerometra i korigiranje koordinata sukladno ocitanjima
void kreciSe()
{
    //Citanje vrijednosti:
    float xA = acc.getAccX();
    float yA = acc.getAccY();
    //Postavljanje brzine:
    if(xA > 0.2){
    if(xA > 0.2 && xA < 0.3) brzina = 0.3;
    if(xA >= 0.3 && xA < 0.4) brzina = 0.1;
    if(xA >= 0.4 && xA < 0.5) brzina = 0.05;
    if(xA >= 0.5 && xA < 0.7) brzina = 0.01;
    if(xA >= 0.7) brzina = 0.01;}
    else if(yA > 0.2){    
    if(yA > 0.2 && yA < 0.3) brzina = 0.3;
    if(yA >= 0.3 && yA < 0.4) brzina = 0.1;
    if(yA >= 0.4 && yA < 0.5) brzina = 0.05;
    if(yA >= 0.5 && yA < 0.7) brzina = 0.01;
    if(yA >= 0.7) brzina = 0.01;}
    else if(xA < -0.2){
    if(xA <-0.2 && xA >-0.3) brzina = 0.3;
    if(xA <= -0.3 && xA > -0.4) brzina = 0.1;
    if(xA <= -0.4 && xA > -0.5) brzina = 0.05;
    if(xA <= -0.5 && xA > -0.7) brzina = 0.01;
    if(xA <= -0.7) brzina = 0.01;}
    else if(yA < -0.2){
    if(yA <-0.2 && yA >-0.3) brzina = 0.3;
    if(yA <= -0.3 && yA > -0.4) brzina = 0.1;
    if(yA <= -0.4 && yA > -0.5) brzina = 0.05;
    if(yA <= -0.5 && yA > -0.7) brzina = 0.01;
    if(yA <= -0.7) brzina = 0.01;}
    
    
    
    //Transfer koordinata
    staroX = novoX;
    staroY = novoY;
    
    if(xA < -0.2 && labirint[novoX + 2][novoY + 1] == 0 && labirint[novoX + 3][novoY] == 0
                && labirint[novoX + 3][novoY - 1] == 0 && labirint[novoX + 2][novoY  - 2] == 0)
        { 
            novoX++;
        }
    if(xA > 0.2 && labirint[novoX - 1][novoY + 1] == 0 && labirint[novoX - 2][novoY] == 0
                && labirint[novoX - 2][novoY - 1] == 0 && labirint[novoX - 1][novoY - 2] == 0)
        novoX--;
    if(yA > 0.2 && labirint[novoX - 1][novoY + 1] == 0 && labirint[novoX][novoY + 2] == 0
                && labirint[novoX + 1][novoY + 2] == 0 && labirint[novoX + 2][novoY + 1] == 0)
        novoY++;
    if(yA < -0.2 && labirint[novoX - 1][novoY - 2] == 0 && labirint[novoX][novoY - 3] == 0
                && labirint[novoX + 1][novoY - 3] == 0 && labirint[novoX + 2][novoY - 2] == 0)
        novoY--;
    
    
}

//Prebacivanje pozicije loptice prema ocitanim vrijednostima u kreciSe()
void obnovi()
{
    //Brisanje stare pozicije:
    lcd.setXYAddress(0,0);
    lcd.clearPixel(staroX - 1, staroY);
    lcd.clearPixel(staroX - 1, staroY - 1);
    lcd.clearPixel(staroX, staroY + 1);
    lcd.clearPixel(staroX, staroY);
    lcd.clearPixel(staroX, staroY - 1);
    lcd.clearPixel(staroX, staroY - 2);
    lcd.clearPixel(staroX + 1, staroY + 1);
    lcd.clearPixel(staroX + 1, staroY);
    lcd.clearPixel(staroX + 1, staroY - 1);
    lcd.clearPixel(staroX + 1, staroY - 2);
    lcd.clearPixel(staroX + 2, staroY);
    lcd.clearPixel(staroX + 2, staroY - 1);
    lcd.refresh();
    //Postavljanje nove pozicije:
    lcd.setXYAddress(0,0);
    lcd.setPixel(novoX - 1, novoY);
    lcd.setPixel(novoX - 1, novoY - 1);
    lcd.setPixel(novoX, novoY + 1);
    lcd.setPixel(novoX, novoY);
    lcd.setPixel(novoX, novoY - 1);
    lcd.setPixel(novoX, novoY - 2);
    lcd.setPixel(novoX + 1, novoY + 1);
    lcd.setPixel(novoX + 1, novoY);
    lcd.setPixel(novoX + 1, novoY - 1);
    lcd.setPixel(novoX + 1, novoY - 2);
    lcd.setPixel(novoX + 2, novoY);
    lcd.setPixel(novoX + 2, novoY - 1);
    lcd.refresh();

    postaviRupu();
    
    if(novoX == 57 && novoY == 24)
        krajIgre = true;
}

//Kraj igre; cisti ekran, ispisuje poruku, vrijeme i uputsvo za pokretanje nove igre
void zavrsiIgru()
{
    sat.stop();
    int sekunde = sat.read();
    int minute = 0;
    while(sekunde > 60)
    {
        sekunde -= 60;
        minute++;
    }
    char ispisVremena[5];
    int desetice = minute / 10;
    int jedinice = minute % 10;
    char m1 = desetice + '0';
    char m2 = jedinice + '0';
    ispisVremena[0] = m1;
    ispisVremena[1] = m2;
    ispisVremena[2] = ':';
    desetice = sekunde / 10;
    jedinice = sekunde % 10;
    m1 = desetice + '0';
    m2 = jedinice + '0';
    ispisVremena[3] = m1;
    ispisVremena[4] = m2;
    
    lcd.clear();
    lcd.setXYAddress(0,0);
    lcd.printString("BRAVO!!!", 0,0);
    lcd.printString("Vase vrijeme:", 0,1);
    lcd.printString(ispisVremena, 0, 2);
    lcd.printString("Dodirnite TSI", 0, 3);
    lcd.printString("za novu igru!", 0, 4);
    lcd.refresh();
    
    float procenat = 0;
    while(1)
    {
         procenat = tsi.readPercentage();
         if(procenat > 0.8)
         {
             lcd.clear();
             lcd.refresh();
             break;
         }
    }
}


int main()
{
    lcd.init();
    inicijalizirajLabirint();
    while(1)
    {
        if(pocetakIgre)
        {
            sat.reset();
            sat.start();
            lcd.setXYAddress(0,0);
            inicijalizirajLabirint();
            novoX = staroX = 2;
            novoY = staroY = 3;
            pocetakIgre = false;
        }
        kreciSe();
        obnovi();

        if(krajIgre)
        {
            zavrsiIgru();
            krajIgre = false;
            pocetakIgre = true;
        }
        wait(brzina);
    }
}
//686