#include "mbed.h"
#include "N5110.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define MAXWIDTH 84
#define MAXHEIGHT 48
#define MMA8451_I2C_ADDRESS (0x1d<<1)

Timer deb;
 //        VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd (PTD0, PTA13, PTA12, PTD5, PTC6, PTC5, PTD4);
// NC u PTC7 u N5110.cpp
//             SDA   SCL    Address
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

TSISensor tsi;
Ticker t;
int X=0;
int Y=0;

bool Sredina=true, Gore=false, Desno=false;
int BrzinaX=0, BrzinaY=0;

void mapa()
{
    for(int i=0; i<84;i++)
     for(int j=0; j<40;j++)
     { 
        if(i==0 || i==83) lcd.setPixel(i,j);
        if(j==0 || j==39) lcd.setPixel(i,j);
     }
     int y=5, i=0, x;
     for(int i=5; i<79;i++) if(i<67 || i>70) lcd.setPixel(i,y); //1
     y=10;
     for(int i=5; i<79;i++) if(i<23 || i>26)  lcd.setPixel(i,y);  //2
     y=15;
     for(int i=5; i<79;i++) lcd.setPixel(i,y); //3
     y=19;
     for(int i=5; i<79; i++) if(i<14 || i>17) lcd.setPixel(i,y); //4
     y=24;
     for(int i=5; i<79; i++) if(i<32 || i>35) lcd.setPixel(i,y); //5
      y=29;
     for(int i=5; i<79; i++) if(i<56 || i>59) lcd.setPixel(i,y); //6
     y=34;
     for(int i=5; i<84; i++) if(i<10 || i>13) lcd.setPixel(i,y); //7
     x=5;
     for(int i=5; i<34; i++) lcd.setPixel(x,i);
     x=78;
     for(int i=5; i<34; i++) lcd.setPixel(x,i);    
     lcd.refresh(); 
     lcd.printString("Nivo:1   Pauza",0,5);
}

void cilj()
{
        for(int i=24; i<28; i++)
         for (int j=16; j<19; j++)
          lcd.setPixel(i,j);
        
        lcd.refresh();
    
}
 
void cursor(int x, int y)
{
        for(int i=x; i<x+3; i++)
         for (int j=y; j<y+3; j++)
          lcd.setPixel(i,j);
        
        lcd.refresh();
    
}

void cursor_main_menua(int x, int y)
{
    for(int i=x; i<x+10; i++)
     for(int j=y; j<y+5; j++)
     {
         lcd.setPixel(i,j);
         
     }
     lcd.refresh();
} 

void cursor_nivoi(int x, int y)
{
    for(int i=x; i<x+14; i++)
     for(int j=y; j<y+5; j++)
     {
         if(lcd.getPixel(i,j)==0) lcd.setPixel(i,j);
         if(lcd.getPixel(i,j)==1) lcd.clearPixel(i,j);
     }
     lcd.refresh();
}
 
void brisi(int x, int y)
{
        for(int i=x; i<x+3; i++)
         for (int j=y; j<y+3; j++)
          lcd.clearPixel(i,j);
        lcd.refresh();
}

void brzina(int n)
{
    switch(n)
        {
            case 0:{ wait(0.07); break;}
            case 1:{ wait(0.06); break;}
            case 2:{ wait(0.05); break;}
            case 3:{ wait(0.04); break;}
            case 4:{ wait(0.03); break;}
            case 5:{ wait(0.02); break;}
        }
}
 
void KLijevo(int &x, int &y)
{
    if(x>1 && lcd.getPixel(x-1,y)==0 && lcd.getPixel(x-1,y+1)==0 && lcd.getPixel(x-1,y+2)==0 ){
        brisi(x,y);
        x=x-1;
        cursor(x,y);
        brzina(BrzinaX);
    }
}
 
void KDesno(int &x, int &y)
{
    if(x<80 && lcd.getPixel(x+3,y) ==0 && lcd.getPixel(x+3,y+1) ==0 && lcd.getPixel(x+3,y+2) ==0 || (x+3)==24 || (x+3)==25 || (x+3)==26){
        brisi(x,y);
        x=x+1;
        cursor(x,y);
        brzina(BrzinaX);
    }
}
 
void KGore(int &x, int &y)
{
    if(y>1 && lcd.getPixel(x,y-1)==0 && lcd.getPixel(x+1,y-1)==0 && lcd.getPixel(x+2,y-1)==0){
        brisi(x,y);
        y=y-1;
        cursor(x,y);
        brzina(BrzinaY);
    }
}
 
void KDolje(int &x, int &y)
{
    if(y<36 && lcd.getPixel(x,y+3)==0 && lcd.getPixel(x+1,y+3)==0 && lcd.getPixel(x+2,y+3)==0){
        brisi(x,y);
        y=y+1;
        cursor(x,y);
        brzina(BrzinaY);
    }
}

void SDesno()
{
    if(Sredina || Desno) 
    {
        Desno = true ; Sredina=false; 
        if(BrzinaX<5) BrzinaX++; 
        KDesno(X,Y);
    }
    if(!Sredina && !Desno)
    {
        if(BrzinaX>0) BrzinaX--;
        if(BrzinaX==0) Sredina=true;
        KLijevo(X,Y);
    }
}

void SLijevo()
{
    if(Sredina || !Desno) {Desno = false ; Sredina=false; if(BrzinaX<5) BrzinaX++;KLijevo(X,Y); }
    if(!Sredina && Desno)
    {
        if(BrzinaX>0) BrzinaX--;
        if(BrzinaX==0) Sredina=true;
        KDesno(X,Y);
    }
}

void SGore()
{
    if(Sredina || Gore) {Gore = true ; Sredina=false; if(BrzinaY<5) BrzinaY++; KGore(X,Y);}
    if(!Sredina && !Gore)
    {
        if(BrzinaY>0) BrzinaY--;
        if(BrzinaY==0) Sredina=true;
        KDolje(X,Y);
    }
}

void SDole()
{
    if(Sredina || !Gore) {Gore = false ; Sredina=false; if(BrzinaY<5) BrzinaY++;  KDolje(X,Y);}
    if(!Sredina && Gore)
    
    {
        if(BrzinaY>0) BrzinaY--;
        if(BrzinaY==0) Sredina=true;
        KGore(X,Y);
    }
}

void kretanje()
{
        
        float x, y;
        x = (acc.getAccX());
        y = (acc.getAccY());
        if(y<-0.5) SLijevo();
        if(y>0.5) SDesno();
        if(x<-0.5) SGore(); 
        if(x>0.5) SDole();      
        if((x<0.5 && x>-0.5) || (y<0.5 && y>-0.5)) Sredina=true;  
        
} 

void kreni()
{ 
    int n=0;
    lcd.clear();
                X=1; Y=1;
                cursor(X,Y);
                mapa();
                cilj();
                int a=0;
                while(a==0)
                { 
                    kretanje();
                    if(X==24 && Y==16) 
                    {
                         lcd.clear();
                         lcd.printString("Pobjeda", 20,3);
                         wait(3);
                         lcd.clear();
                         a=1;
                    }
                    if(tsi.readPercentage()>0.6) n=1;
                       while(n==1)
                    {
                        wait(0.001);
                        if(tsi.readPercentage()>0.4) n=2;
                    }
                }              
}

void menu()
{
    int n=1;
    lcd.printString("New Game", 5,1);
    lcd.printString("Level",5,2);
    cursor_main_menua(54, 10);
    lcd.refresh();
    while(1)
    {
        
        float x;
        x = (acc.getAccX());    
        if(x<-0.5) n=1; 
        if(x>0.5) n=2; 
        if(n==2)
        {
                lcd.clear();
                lcd.printString("New Game", 5,1);
                lcd.printString("Level",5,2);
                cursor_main_menua(54, 17);
                
        }
        if(n==1)
        {
                lcd.clear();
                lcd.printString("New Game", 5,1);
                lcd.printString("Level",5,2);
                cursor_main_menua(54, 10);
                
        }
        if(tsi.readPercentage()>0.0)
        {
            if(n==1)
            {
                kreni();
            }
            if(n==2)
            {
                
                lcd.clear();
                lcd.printString("Level 1", 5,1);
                lcd.printString("Touch to", 5,3);
                lcd.printString("START", 5,4);
                wait(1);
                while(1)
                if(tsi.readPercentage()>0.0) kreni();
            }
         }
     }
} 
 
int main(){
  deb.start();
  lcd.init();
  lcd.setXYAddress(X,Y);
  lcd.setBrightness(0.0);
  
  menu();
  while(1){
  }
}