#include "mbed.h"
#include "TSISensor.h"

PwmOut red(LED_RED);
PwmOut green(LED_GREEN);
PwmOut blue(LED_BLUE);

Serial pc(USBTX, USBRX);
TSISensor tsi;

Ticker tSenzor;

void ispisSenzora()
{
    pc.printf("Vrijednost TSI senzora: %.2f %%\n", tsi.readPercentage());

}

int main()
{
    red = 1.0f;
    green = 1.0f;
    blue = 1.0f;
    

    while(1)
    {
        char c = pc.getc();
        
        if(c=='P') tSenzor.attach(&ispisSenzora, 1);
        
        else if(c=='Z') tSenzor.detach();
        
        else if(c=='R' || c=='G' || c=='B')
        {
            int d((pc.getc() - '0') * 10);
            int j(pc.getc() - '0');
            
            red = green = blue = 1.0f; // iskljuciSve
            
            float intenzitet((d+j)/100.);
            
            if(c=='R') red = 1.0 - intenzitet;
            else if(c=='G') green = 1.0 - intenzitet;
            else blue = 1.0 - intenzitet;
        
        }
        
        
    
    }

}