#include "mbed.h"
#include "N5110.h"

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);

DigitalIn taster1(dp1);
DigitalIn taster2(dp2);

//Digitalni izlaz za aktivaciju LED buffera
DigitalOut enable(dp14);
DigitalOut  prikazSW(dp23);

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

void postaviKursor(int x, int y) {
    for(int i(1);i<5;i++) {
        lcd.setPixel(x+i,y);
        lcd.setPixel(x,y+i);
        lcd.setPixel(x-i,y);
        lcd.setPixel(x,y-i);
    }
}

void nacrtajPravougaonik(int x1,int y1,int x2,int y2) {
    for(int i=0;i<abs(x2-x1);i++)
        {
            for(int j(0);j<abs(x1-x2);j++) {
                lcd.setPixel(x1+j,y1+i);
            }
        }
    for(int i=0;i<abs(y2-y1);i++) {
        for(int j(0);j<abs(y1-y2);j++) {
            lcd.setPixel(x1+i,y1+j);
        }
    }  
}

int main()
{
    //deaktivacija LED dioda
    enable=1;
    //Aktivacija pull-up otpornika
    SW.mode(PullUp);
    int brKlikova(0);
    lcd.init();
    lcd.setXYAddress(0,0);
    int x(0),y(0),tacka1x(-1),tacka1y(-1),tacka2x(-1),tacka2y(-1);
    
    while(1) {
        lcd.clear();
        
        if(VRx<1.0/3.0) {    
            if (x>0) {
                x--;
            }
        }       
        
        else if (VRx>2.0/3.0) {
            if(x<83) {
                x++;  
            }
        }      
        
        if (VRy<1.0/3.0) {
            if(y>0) {
                y--;
            }
        }
                
        else if (VRy>2.0/3.0) {
            if(y<47) {
                y++;
            }
        }
        
        postaviKursor(x,y);
        if(taster1==1) {
            if(tacka1x==-1) {
                tacka1x=x;
                tacka1y=y;
            }
            else {
                tacka2x=x;
                tacka2y=y;
            }                
        }
        if(tacka1x!=-1 && tacka1y!=-1)
            lcd.setPixel(tacka1x,tacka1y);

            
        if(tacka1x!=-1 && tacka1y!=-1 && tacka2x!=-1 && tacka2y!=-1)
            nacrtajPravougaonik(tacka1x,tacka1y,tacka2x,tacka2y);
        
        if(taster2==1) {
            if(brKlikova<2)
                brKlikova++;
        }
        if(brKlikova==2) {
            lcd.clear();
            brKlikova=0;
        }}+
        if (SW==1) prikazSW=1;
        else prikazSW=0;
        lcd.refresh();
        wait(0.01);
    }
}