#include "mbed.h"
#include "N5110.h"

N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
InterruptIn SW(dp9);

int xmin=0,xmax=0;
int ymin=0,ymax=0;

Timer press;
Ticker ticker;
bool set=true;

int first[2]={0,0};
int second[2]={0,0};
int point[2]={0,0};

bool crosshair[4]={false};

void setX()
{   
    if(first[0]<second[0])
    {
        xmin=first[0];
        xmax=second[0];
    }
    else
    {
        xmin=second[0];
        xmax=first[0];
    }
}

void setY()
{
    
    if(first[1]<second[1])
    {
        ymin=first[1];
        ymax=second[1];
    }
    else
    {
        ymin=second[1];
        ymax=first[1];
    }
}



    
void readX()
{  
    if(VRx<1.0/3.3)
        point[0]--;
    if(VRx>2.0/3.3)
        point[0]++;
        
}
void readY()
{
   if(VRy<1.0/3.3)
        point[1]--;
    if(VRy>2.0/3.3)
        point[1]++;
        
}

 

void displayCrosshair()
{
  int points[4]={point[0]-1,point[0]+1,point[1]-1,point[1]+1};
  if(points[0]>0&&lcd.getPixel(points[0],point[1])==0)
  {
     lcd.setPixel(points[0],point[1]);
     crosshair[0]=true;
  }
  if(points[1]<83&&lcd.getPixel(points[1],point[1])==0)
  {
    lcd.setPixel(points[1],point[1]);
    crosshair[1]=true;
  }
  if(points[2]>0&&lcd.getPixel(point[0],points[2])==0)
  {
    lcd.setPixel(point[0],points[2]);
    crosshair[2]=true;
  }
  if(points[3]<43&&lcd.getPixel(point[0],points[3])==0)
  {
    lcd.setPixel(point[0],points[3]);
    crosshair[3]=true;
  }      
}

void hideCrosshair()
{
    int points[4]={point[0]-1,point[0]+1,point[1]-1,point[1]+1};
    if(points[0]>0&&crosshair[0])
    {
        lcd.clearPixel(points[0],point[1]);
        crosshair[0]=false;
    }
    if(points[1]<83&&crosshair[1])
    {
        lcd.clearPixel(points[1],point[1]);
        crosshair[1]=false;
    }
    if(points[2]>0&&crosshair[2])
    {
        lcd.clearPixel(point[0],points[2]);
        crosshair[2]=false;
    }
    if(points[3]<43&&crosshair[3])
    {
        lcd.clearPixel(point[0],points[3]);
        crosshair[3]=false;
    }
            
}

void displayPoint()
{
    hideCrosshair();
    lcd.refresh();
   
    readX();
    readY();
    
    displayCrosshair();
    lcd.refresh();
}     


void paint()
{
    setX();
    setY();  
    
    for(int i=xmin;i<=xmax;i++)
    {
        for(int j=ymin;j<ymax;j++)
        {
            lcd.setPixel(i,j);
        }
    }
    lcd.refresh();           
}


void buttonPress()
{
    if(set)
    {
        if(press.read_ms()>200)
        {
            set=!set;
            first[0]=point[0];
            first[1]=point[1];
            lcd.setPixel(first[0],first[1]);
            lcd.refresh();
            press.reset();
        }
    }
    else if(!set)
    {
        if(press.read_ms()>200&&press.read_ms()<500)
        {
            lcd.clear();
            point[0]=15;
            point[1]=15;
            displayPoint();
            press.reset();
            set=!set;
            }
     
       else if(press.read_ms()>200)
        {    second[0]=point[0];
            second[1]=point[1];
            lcd.setPixel(second[0],second[1]);
            paint();
            first[0]=0;
            first[1]=0;
            second[0]=0;
            second[1]=0;
            press.reset();
            set=!set;
         }   
        
        lcd.refresh();
       
        }
     
}

int main() {
    lcd.init();
    lcd.setXYAddress(0,0);
    point[0]=15;
    point[1]=15;
    press.start();
    SW.mode(PullUp);
    SW.rise(buttonPress);
    ticker.attach(displayPoint,0.25);
    while(1) {

    }
}
