#include "mbed.h"
#include "TSISensor.h"
#include <string>

DigitalOut myled(LED1);

Serial pc(USBTX, USBRX);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);

string input;

Ticker ticker;

TSISensor tsi;

void displayTSI()
{
    pc.printf("%f\n",tsi.readPercentage());
}   

void turnOnLed(char color, int ipct)
{
    if(color!='R' && color!='G' && color!='B')
        return;
    pc.printf("%d\n",ipct);   
    led1=1;
    led2=1;
    led3=1;
    float pct=float(ipct)/100;
    
    if(color=='R')
        led1=1-pct;
    else if(color=='G')
        led2=1-pct;
    else
        led3=1-pct;
}

void readFromPC()
{
    while(pc.readable())
    {
        input.push_back(pc.getc());
    }
}

void clearBuffer()
{
    input="";
}

void executeInstruction()
{
    int pct=0;
    if(input.length()>3)
    {
        clearBuffer();
        return;
    }
    if(input.length()>=1)
    if(input[input.length()-1]==13)
    {
        clearBuffer();
        printf("\r");
    }
    if(input.length()==3){
    if((input[0]=='R' || input[0]=='G' || input[0]=='B') && input[1]>='0'&&input[1]<='9' && input[2]>='0'&&input[2]<='9')
    {
        pct=(input[1]-'0')*10+(input[2]-'0');
        turnOnLed(input[0],pct);
        clearBuffer();
         pc.printf("\n");
    }
    }
    else if(input.length()==1){
        if(input[0]=='P')
        {
            ticker.attach(displayTSI,1.0);
            pc.printf("\n");
            clearBuffer();
        }
        else if(input[0]=='Z')
        {
             ticker.detach();
             pc.printf("\n");
             clearBuffer();
        }

   }         
}


int main(){
    led1=1;
    led2=2;
    led3=3;
    while(1) {
        readFromPC();
        executeInstruction();
    }
}
