#include "mbed.h"
#include "N5110.h"
 
//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);
 
//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
 
 
//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);
 
//koordinate crosshair kursora / na sredini ekrana
int x1(40), y1(23), x2(41), y2(22), x3(42), y3(23), x4(41), y4(24);

//koordinate virtuelnog kursora koji nam govori jesmo li u pravougaoniku
 int vx1(-1), vy1(-1), vx2(-1), vy2(-1), vx3(-1), vy3(-1), vx4(-1), vy4(-1);
 
//koordinate tacaka dijagonala 
int xd1(-1), yd1(-1), xd2(-1), yd2(-1);
 
//taster za dodavanje tacke/ brisanje svih tacaka
InterruptIn taster1(dp1);
 
// timer koji mjeri vrijeme izmedju dva tastera
Timer timer; 
 
//funkcija za pravljenje pravougaonika kad vec imamo tacke dijagonale
void makeRectangle()
{
    taster1.disable_irq();
    int Ax, Ay, Bx, By, Cx, Cy, Dx, Dy;
    if( xd1  < xd2 && yd1 > yd2 )
    {
        Bx = xd2;
        By = yd2;
        Dx = xd1;
        Dy = yd1;
        
        Ax = Dx;
        Ay = By;
        Cx = Bx;
        Cy = Dy;
    }
    else if(  xd2  < xd1 && yd2 > yd1 ) 
    {
        Bx = xd1;
        By = yd1;
        Dx = xd2;
        Dy = yd2;
    
        Ax = Dx;
        Ay = By;
        Cx = Bx;
        Cy = Dy;    
    }
    else if ( xd1 < xd2 && yd1 < yd2 )
    {
        Ax = xd1;
        Ay = yd1;
        Cx = xd2;
        Cy = yd2;
        
        Bx = Cx;
        By = Ay;
        Dx = Ax;
        Dy = Cy;
    }
    else if ( xd2 < xd1 && yd2 < yd1 )
    {
        Ax = xd2;
        Ay = yd2;
        Cx = xd1;
        Cy = yd1;
        
        
        Bx = Cx;
        By = Ay;
        Dx = Ax;
        Dy = Cy; 
    }
    
    int i, j;
    // crtamo pravougaonik
    for( i = Ay; i <= Dy; i++)
    for( j = Ax; j <= Cx; j++)
    {
        lcd.setPixel(j,i);
    }
        lcd.refresh();
        lcd.setXYAddress(0,0);
    taster1.enable_irq();
}
 
// funkcija za dodavanje tacke dijagonale/ pravljenje pravougaonika
 
void setPoint()
{
 if( timer.read_ms() < 200) return;
 if(timer.read_ms() <= 1000)
 {
     lcd.clear();
     xd1 = -1;
     yd1 = -1;
     xd2 = -1;
     yd2 = -1;
     x1 = 40;
     y1 = 23; 
     x2 = 41;
     y2 = 22;
     x3 = 42;
     y3 = 23;
     x4 = 41;
     y4 = 24;
     vx1 =  -1;
     vy1 =  -1;
     vx2 =  -1;
     vy2 =  -1;
     vx3 =  -1;
     vy3 =  -1;
     vx4 =  -1;
     vy4 =  -1;
     lcd.setPixel(x1,y1);
     lcd.setPixel(x2,y2);
     lcd.setPixel(x3,y3);
     lcd.setPixel(x4,y4);
     lcd.refresh();
     lcd.setXYAddress(0,0);
     timer.reset();
     return;
 }  
 if( xd1 < 0 )
 {
     xd1 = x2;
     yd1 = y1;
     lcd.setPixel(xd1, yd1);
     lcd.refresh();
     lcd.setXYAddress(0,0);
 }
 else 
 {
     if( x2 != xd1 && y1 != yd1)
     {
     xd2 = x2;
     yd2 = y1;
     makeRectangle();
     xd1 = -1;
     yd1 = -1;
     xd2 = -1;
     yd2 = -1;
     }
 }
  timer.reset();
 }
 
int main()
{
    
    timer.start();
    
    taster1.rise(&setPoint);
   
     enable=1;
 
    // inicijalizacija displaya
    lcd.init();
    lcd.setXYAddress(0,0);
    
    lcd.normalMode();
    
    lcd.setPixel(x1,y1);
    lcd.setPixel(x2,y2);
    lcd.setPixel(x3,y3);
    lcd.setPixel(x4,y4);
    lcd.refresh();
    lcd.setXYAddress(0,0);
    
    while(1) {
        if (VRx < 1.0/3.0 && x1 > 0 ) 
        {
            if( vx1 == -1)
            lcd.clearPixel(x1,y1);
            if( vx2 == -1)
            lcd.clearPixel(x2,y2);
            if( vx3 == -1)
            lcd.clearPixel(x3,y3);
            if( vx4 == -1)
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            lcd.setXYAddress(0,0);
            
            x1--;
            x2--;
            x3--;
            x4--;
            
             if( lcd.getPixel(x1, y1))
            {
            vx1 = x1;
            vy1 = y1;
            }
            else
            {
            vx1 = -1;
            vy1 = -1;
            }
             if( lcd.getPixel(x2, y2))
            {
            vx2 = x2;
            vy2 = y2;
            }
            else
            {
            vx2 = -1;
            vy2 = -1;
            }
            
            if( lcd.getPixel(x3, y3))
            {
            vx3 = x3;
            vy3 = y3;
            }
            else
            {
            vx3 = -1;
            vy3 = -1;
            }
            
             if( lcd.getPixel(x4, y4))
            {
            vx4 = x4;
            vy4 = y4;
            }
            else
            {
            vx4 = -1;
            vy4 = -1;
            }      
        }
        else if (VRx > 2.0/3.0 && x3 < 47)
        {
              if( vx1 == -1)
            lcd.clearPixel(x1,y1);
            if( vx2 == -1)
            lcd.clearPixel(x2,y2);
            if( vx3 == -1)
            lcd.clearPixel(x3,y3);
            if( vx4 == -1)
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            lcd.setXYAddress(0,0);
            x1++;
            x2++;
            x3++;
            x4++;
            
            if( lcd.getPixel(x1, y1))
            {
            vx1 = x1;
            vy1 = y1;
            }
            else
            {
            vx1 = -1;
            vy1 = -1;
            }
             if( lcd.getPixel(x2, y2))
            {
            vx2 = x2;
            vy2 = y2;
            }
            else
            {
            vx2 = -1;
            vy2 = -1;
            }
            
            if( lcd.getPixel(x3, y3))
            {
            vx3 = x3;
            vy3 = y3;
            }
            else
            {
            vx3 = -1;
            vy3 = -1;
            }
            
             if( lcd.getPixel(x4, y4))
            {
            vx4 = x4;
            vy4 = y4;
            }
            else
            {
            vx4 = -1;
            vy4 = -1;
            }           
        }
 
        if ( VRy < 1.0/3.0 && y2 > 0) 
         {
              if( vx1 == -1)
            lcd.clearPixel(x1,y1);
            if( vx2 == -1)
            lcd.clearPixel(x2,y2);
            if( vx3 == -1)
            lcd.clearPixel(x3,y3);
            if( vx4 == -1)
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            lcd.setXYAddress(0,0);
            
            y1--;
            y2--;
            y3--;
            y4--;
                     
             if( lcd.getPixel(x1, y1))
            {
            vx1 = x1;
            vy1 = y1;
            }
            else
            {
            vx1 = -1;
            vy1 = -1;
            }
             if( lcd.getPixel(x2, y2))
            {
            vx2 = x2;
            vy2 = y2;
            }
            else
            {
            vx2 = -1;
            vy2 = -1;
            }
            
            if( lcd.getPixel(x3, y3))
            {
            vx3 = x3;
            vy3 = y3;
            }
            else
            {
            vx3 = -1;
            vy3 = -1;
            }
            
             if( lcd.getPixel(x4, y4))
            {
            vx4 = x4;
            vy4 = y4;
            }
            else
            {
            vx4 = -1;
            vy4 = -1;
            }        
        }
        else if (VRy > 2.0/3.0 && y4 < 83) 
         {
              if( vx1 == -1)
            lcd.clearPixel(x1,y1);
            if( vx2 == -1)
            lcd.clearPixel(x2,y2);
            if( vx3 == -1)
            lcd.clearPixel(x3,y3);
            if( vx4 == -1)
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            lcd.setXYAddress(0,0);
            
            y1++;
            y2++;
            y3++;
            y4++;
            
             if( lcd.getPixel(x1, y1))
            {
            vx1 = x1;
            vy1 = y1;
            }
            else
            {
            vx1 = -1;
            vy1 = -1;
            }
             if( lcd.getPixel(x2, y2))
            {
            vx2 = x2;
            vy2 = y2;
            }
            else
            {
            vx2 = -1;
            vy2 = -1;
            }
            
            if( lcd.getPixel(x3, y3))
            {
            vx3 = x3;
            vy3 = y3;
            }
            else
            {
            vx3 = -1;
            vy3 = -1;
            }
            
             if( lcd.getPixel(x4, y4))
            {
            vx4 = x4;
            vy4 = y4;
            }
            else
            {
            vx4 = -1;
            vy4 = -1;
            }      
            
        }
       
 
            lcd.setPixel(x1,y1);
            lcd.setPixel(x2,y2);
            lcd.setPixel(x3,y3);
            lcd.setPixel(x4,y4);
            lcd.refresh(); 
            lcd.setXYAddress(0,0);
            
        wait(0.01);
 
     }
}