#include "mbed.h"
#include "N5110.h"
#include <vector>
#include <string>

N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
InterruptIn SW(dp9);


int level=1;
float brzina=0.3;
int pojela=0;
int smjer_trenutni=2;
Ticker tiker1;
Ticker tiker2;
int hranax;
int hranay;
int score=0;
//1-gore 2-desno 3-dolje 4-lijevo
int smjer_zeljeni=2; // ide desno
vector<int> vecx;
vector<int> vecy;

void ispisSkora()
{
    
    //
    //brisanje sadrzaja
    //
    int elma,ilvana;
    for(elma=0;elma<=39;elma++)
    for(ilvana=39;ilvana<=48;ilvana++)
    lcd.clearPixel(elma,ilvana);
    
    if(pojela==0)
    {
        lcd.printString("SC: 0 ",0,5);
    }
    else if(pojela==1)
    {
        lcd.printString("SC: 1 ",0,5);
    }
    else if(pojela==2)
    {
        lcd.printString("SC: 2 ",0,5);
    }
    else if(pojela==3)
    {
        lcd.printString("SC: 3 ",0,5);
    }
    else if(pojela==4)
    {
        lcd.printString("SC: 4 ",0,5);
    }
    else if(pojela==5)
    {
        lcd.printString("SC: 5 ",0,5);
    }
    else if(pojela==6)
    {
        lcd.printString("SC: 6 ",0,5);
    }
    else if(pojela==7)
    {
        lcd.printString("SC: 7 ",0,5);
    }
     else if(pojela==8)
    {
        lcd.printString("SC: 8 ",0,5);
    }
     else if(pojela==9)
    {
        lcd.printString("SC: 9 ",0,5);
    }
     else if(pojela==10)
    {
        lcd.printString("SC: 10",0,5);
    }
}

void ispisLevela()
{
     //
    //brisanje sadrzaja
    //
    int elma,ilvana;
    for(elma=40;elma<=84;elma++)
    for(ilvana=39;ilvana<=48;ilvana++)
    lcd.clearPixel(elma,ilvana);
    if(level==1)
    {
        lcd.printString("LV: 1",40,5);
    }
    else if(level==2)
    {
        lcd.printString("LV: 2",40,5);
    }
    else if(level==3)
    {
        lcd.printString("LV: 3",40,5);
    }
}
void ispisKockice(int x,int y)//zmija debela 2x2, tri kvadratica
{
    int i,j;
    for(i=x; i<x+2; i++)
        for(j=y; j<y+2; j++)
            lcd.setPixel(i,j);
}
bool da_li_je_na_zmiji(int x,int y)//za hranu
{
    int i,j;
    for(i=0; i<vecx.size(); i++)
            if(vecx[i]==x && vecy[i]==y)return true;

    return false;
}
void crtanje_hrane()
{
    int i,j;
    for(i=0; i<2; i++)
        for(j=0; j<2; j++)
            lcd.setPixel(hranax+i,hranay+j);
    lcd.refresh();
}
void pobjeda()
{
    lcd.clear();
    lcd.printString("Pobjeda!",2,2);
    lcd.printString("SC: 30", 2,3);
}
    
void generisanje_hrane()
{
    hranax=rand()%80 + 2;
    hranay = rand()%36 + 2;
    if(hranax%2==1 && hranax==3)hranax=hranax+1;
    if(hranax%2==1)hranax=hranax-1;
    if(hranay%2==1 && hranay==3)hranay=hranay+1;
    if(hranay%2==1)hranay=hranay-1;

    while(da_li_je_na_zmiji(hranax,hranay))
        generisanje_hrane();

    crtanje_hrane();
    lcd.refresh();

}
bool daLiJePogodila()
{
    //1-gore 2-desno 3-dolje 4-lijevo
    if(smjer_zeljeni==1)
    {
        if(hranax==vecx[0] && hranay==vecy[0]-2)
            return true;
    }
    else if(smjer_zeljeni==2)
    {
        if(hranax==vecx[0]+2 && hranay==vecy[0])
            return true;
    }
    else if(smjer_zeljeni==3)
    {
        if(hranax==vecx[0] && hranay==vecy[0]+2)
            return true;
    }
    else if(smjer_zeljeni==4)
    {
        if(hranax==vecx[0]-2 && hranay==vecy[0])
            return true;
    }
    
    return false;

}

void  SmjerZmije()
{
    if(VRx<1.0/3.0) { smjer_trenutni=smjer_zeljeni;smjer_zeljeni=4; }
    else if(VRx>2.0/3.0) { smjer_trenutni=smjer_zeljeni;smjer_zeljeni=2;}
    else if(VRy<1.0/3.0){ smjer_trenutni=smjer_zeljeni;smjer_zeljeni=1;}
    else if(VRy>2.0/3.0){ smjer_trenutni=smjer_zeljeni;smjer_zeljeni=3;}
    else return;
}
void sortiranje(vector<int> &v)
{
    int x=v[v.size()-1];
    int i;
    for(i=v.size()-1; i>0; i--)
        v[i]=v[i-1];
    v[0]=x;
}
bool daLiJeUdarilaZid()
{
    if(smjer_zeljeni==1 && vecy[0]==2 )return true;
    if(smjer_zeljeni==2 && vecx[0]==80 )return true;
    if(smjer_zeljeni==3 && vecy[0]==36 )return true;
    if(smjer_zeljeni==4 && vecx[0]==2 )return true;
    return false;
}
 int jedan=0;
    int dva=0;
    int tri=0;
    int cetiri =0;
bool daLiJeUdarilaUSebe()
{
   
    if(smjer_trenutni==1 && smjer_zeljeni==3){jedan++;return false;}
     if(smjer_trenutni==2 && smjer_zeljeni==4){dva++;return false;}
    if(smjer_trenutni==3 && smjer_zeljeni==1){tri++;return false;}
     if(smjer_trenutni==4 && smjer_zeljeni==2){cetiri++;return false;}
     if(smjer_zeljeni==1)
    {
        if(tri>0){ tri=0;return false;}
       
        int i;
        for(i=0;i<vecx.size();i++)
         if(vecx[0] == vecx[i] && vecy[0]-2== vecy[i])return true;
    }
     if(smjer_zeljeni==2)
    {
        if(cetiri>0){cetiri=0;return false;}
       
        int i;
        for(i=0;i<vecx.size();i++)
         if(vecx[0]+2 == vecx[i] && vecy[0]== vecy[i])return true;
    }
     if(smjer_zeljeni==3)
    {
        if(jedan>0){jedan=0;return false;}
        jedan=0;
        int i;
        for(i=0;i<vecx.size();i++)
         if(vecx[0] == vecx[i] && vecy[0]+2== vecy[i])return true;
    }
    if(smjer_zeljeni==4)
    {
        if(dva>0){dva=0;return false;}
        
        int i;
        for(i=0;i<vecx.size();i++)
         if(vecx[0]-2 == vecx[i] && vecy[0]== vecy[i])return true;
    }

     return false;
}
void game_over()
{
    lcd.clear();
    lcd.printString("GAME OVER",2,2);
    ispisSkora();
    ispisLevela();
}
void inicijalizacijaEkrana()
{
    int i;
    for(i=1; i<=82; i++)
    {
        lcd.setPixel(i,1);
        lcd.setPixel(i,38);
    }
    for(i=1; i<=38; i++)
    {
        lcd.setPixel(1,i);
        lcd.setPixel(82,i);
    }
    ispisLevela();
    ispisSkora();
    ispisKockice(16,16);
    ispisKockice(18,16);
    ispisKockice(20,16);

    vecx.push_back(20);
    vecx.push_back(18);
    vecx.push_back(16);

    vecy.push_back(16);
    vecy.push_back(16);
    vecy.push_back(16);
}


void brisanjeKockice(int x,int y)
{
    int i,j;
    for(i=x; i<x+2; i++)
        for(j=y; j<y+2; j++)
            lcd.clearPixel(i,j);
            //lcd.reffresh();
}

void kretanje()//1-gore 2-desno 3-dolje 4-lijevo
{
    SmjerZmije();
    if(daLiJeUdarilaZid())
    {
        lcd.refresh();
        game_over();
        lcd.refresh();
       tiker1.detach();
    }
    if(daLiJeUdarilaUSebe())
    {
        lcd.refresh();
        game_over();
        lcd.refresh();
        tiker1.detach();
    }
    if(daLiJePogodila())
    {
        vecx.push_back(hranax);
        vecy.push_back(hranay);
        sortiranje(vecx);
        sortiranje(vecy);
        pojela++;
        generisanje_hrane();
        score++;
        if(pojela<10)
        {
        ispisSkora();
        lcd.refresh();
        return;
        }
        else if(pojela==10)
        {
            ispisSkora();
            if(level==3)
            {
                 pobjeda();
                 lcd.refresh();
                tiker1.detach();
            }
            else
            {
            level++;
            ispisLevela();
            brzina-=0.1;
            tiker1.detach();
            tiker1.attach(&kretanje,brzina);
            pojela=0;
            }
            
        }

    }
    if(smjer_trenutni==1&&smjer_zeljeni==3)
    {
        brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
        vecy[vecy.size()-1]=vecy[0]-2;
        vecx[vecx.size()-1]=vecx[0];
        sortiranje(vecy);
        sortiranje(vecx);
        int i;
        //for(i=0;i<vecx.size();i++)
        ispisKockice(vecx[0],vecy[0]);
        lcd.refresh();
    }
    if(smjer_trenutni==2&&smjer_zeljeni==4)
        if(smjer_zeljeni==2)//nastavlja da se krece prema desno
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]+2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
    if(smjer_trenutni==3&&smjer_zeljeni==1)
    {
        brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
        vecy[vecy.size()-1]=vecy[0]+2;
        vecx[vecx.size()-1]=vecx[0];
        sortiranje(vecy);
        sortiranje(vecx);
        int i;
        //for(i=0;i<vecx.size();i++)
        ispisKockice(vecx[0],vecy[0]);
        lcd.refresh();
    }
    if(smjer_trenutni==4&&smjer_zeljeni==2)
    {
        brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
        vecy[vecy.size()-1]=vecy[0];
        vecx[vecx.size()-1]=vecx[0]-2;
        sortiranje(vecy);
        sortiranje(vecx);
        int i;
        //for(i=0;i<vecx.size();i++)/// sta ce nam ovo
        ispisKockice(vecx[0],vecy[0]);
        lcd.refresh();
    }
    if(smjer_trenutni==1)
    {
        if(smjer_zeljeni==1)//isao je prema gore i nastavlja kretanje prema gore
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]-2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==2)//isao je gore i skrece ka desno
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]+2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==4)//isao je gore i skrece ka lijevo
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]-2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }

    }
    if(smjer_trenutni==2)//isao je desno
    {
        if(smjer_zeljeni==1)//isao je desno i ide sad prema goree
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]-2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==2)//nastavlja da se krece prema desno
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]+2;
            sortiranje(vecy);
            sortiranje(vecx);
            
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==3)//isao je desno i pocinje da se krece prema dolje
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]+2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }

    }
    if(smjer_trenutni==3)//ide prema dolje
    {
        if(smjer_zeljeni==2)//isao je prema dolje i zeli da ide desno
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]+2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==3)//nastavlja da se krece prema dolje
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]+2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==4)//kretao se prema dolje i hoce da ide lijevo
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]-2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }

    }
    if(smjer_trenutni==4)//kretao se lijevoo
    {
        if(smjer_zeljeni==1)// kretao se lijevo i sad ide gore
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]-2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==3)//kretao se lijevo i sad ide dolje
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0]+2;
            vecx[vecx.size()-1]=vecx[0];
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }
        if(smjer_zeljeni==4)//nastavlja kretanje lijevo
        {
            brisanjeKockice(vecx[vecx.size()-1],vecy[vecy.size()-1]);
            vecy[vecy.size()-1]=vecy[0];
            vecx[vecx.size()-1]=vecx[0]-2;
            sortiranje(vecy);
            sortiranje(vecx);
            int i;
            //for(i=0;i<vecx.size();i++)/// sta ce nam ovo
            ispisKockice(vecx[0],vecy[0]);
            lcd.refresh();
        }

    }
    lcd.refresh();
}
void novaIgra()
{
    tiker1.detach();
    lcd.clear();
    pojela=0;
    level=1;
    ispisSkora();
    ispisLevela();
    brzina=0.3;
    vecx.resize(0);
    vecy.resize(0);
    inicijalizacijaEkrana();
    generisanje_hrane();
    tiker1.attach(&kretanje,brzina);
   
    
}


int main()
{
    SW.mode(PullUp);
    lcd.init();
    lcd.setXYAddress(0,0);
       inicijalizacijaEkrana();    
        lcd.refresh();
        
        generisanje_hrane();
        lcd.refresh();
       
         tiker1.attach(&kretanje,brzina);
       
         SW.rise(&novaIgra);
    while(1)
    {
       
    }
}