#include "mbed.h"
 
Serial pc(USBTX, USBRX);
Ticker prikaz;
BusOut motor(dp13, dp11, dp10, dp9); //IN1, IN2, IN3, IN4
int anticlockwise[8] = {1, 3, 2, 6, 4, 12, 8, 9};
int clockwise[8] = {9, 8, 12, 4, 6, 2, 3, 1};
int stop_time = 1000;
int cur = 0;
bool pokrenut = false;
int *smjer = clockwise;

void rotate(int *step,int koraka = 8)
{
    for(int i = 0; i < koraka; i++) 
    {
        motor = step[i];
        wait_us(stop_time);
    }
}


void vrti()
{
    if(pokrenut) rotate(smjer);   
}

 
int main() 
{


    prikaz.attach_us(vrti, 20 * stop_time); 
    pc.printf("1-Pokreni motor\n");
    pc.printf("2-Promijeni smjer\n");
    pc.printf("3-Promijeni brzinu\n");
    pc.printf("4-Zaustavi motor\n");
    pc.printf("5-Pomjeri za korak\n");
 
    while (1) {
        char komanda = pc.getc();
        if (komanda == '1') pokrenut = true; 
        if (komanda == '2') smjer = ((smjer == clockwise) ? anticlockwise : clockwise);
        if (komanda == '3')
        {
            prikaz.detach();
            int broj = 0;
            char c;
            bool greska = false;
            pc.printf("Trenutno vrijeme pauze %f ms\n", stop_time);
            pc.printf("Unesi vrijeme u ms . za kraj\n");
            c = pc.getc();
            while(c != '.')
            {
                broj *= 10;
                if(c < '0' || c > '9') 
                {
                    pc.printf("Greska u unosu.\n");
                    greska = true;
                }
                broj += (c - '0');
                c = pc.getc();
            }
            if(!greska && broj != 0) stop_time = broj;
            prikaz.attach_us(vrti, 20 * stop_time);
        }
        if (komanda=='4') pokrenut = false;
        if (komanda=='5') 
        {
            prikaz.detach();
            int broj = 0;
            char c;
            bool greska = false;
            pc.printf("Unesi broj koraka . za kraj\n");
            c = pc.getc();
            while(c != '.')
            {
                broj *= 10;
                if(c < '0' || c > '9') 
                {
                    pc.printf("Greska u unosu.\n");
                    greska = true;
                }
                broj += (c - '0');
                c = pc.getc();
            }
            for(int i =0; i < broj; i++) rotate(smjer, broj);
        }
        
    }
}
