POLUDVOSMJERNI:

//defaultni receiver

#include "mbed.h"
#include "nRF24L01P.h"
#include "string.h"
#define sirina 4

nRF24L01P wifi(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);
Serial pc(USBTX, USBRX);

char podaci[sirina];
char terminal[100];
int rxDataCnt = 0;
char rxData[sirina];

int main()
{   
    wifi.powerUp();
    wifi.setTransferSize(sirina);
    wifi.setRfFrequency();
    wifi.setAirDataRate();
    wifi.setCrcWidth();
    wifi.setRfOutputPower();
    
    podaci[0] = 'a';
    podaci[1] = 'd';
    podaci[2] = 'n';
    podaci[3] = 'a';

    while(1){
        wifi.setReceiveMode();
        wifi.enable();
        if ( wifi.readable() ) {
            rxDataCnt = wifi.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            pc.puts("\nOsoba1: "); 
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                pc.putc( rxData[i] );
            }
        }
        wait(0.1);
        
        wifi.setTransmitMode();
    pc.puts("\nOsoba2: ");
        wifi.write(NRF24L01P_PIPE_P0, podaci, sirina);
        wait(0.1);
     }   
}

// defaultni transmiter

#include "mbed.h"
#include "nRF24L01P.h"
#define sirina 4

Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P wifi(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);    // mosi, miso, sck, csn, ce, irq

char rxData[sirina];
int rxDataCnt = 0;
int i = 0, j, k;
char znak = '.';
char podaci[sirina];

int main() {
    pc.printf("Chat:\n");
    wifi.setRfFrequency();
    wifi.setAirDataRate();
    wifi.powerUp();
    wifi.setCrcWidth();
    wifi.setRfOutputPower();
    
    while(1)
    {
        wifi.setTransmitMode();
        wifi.enable();
        pc.puts("\Osoba1:\n");
        while(znak != '.' && i < 100)
        {
            j = 0;
            while(j < 4)
            {
                znak = pc.getc();
                if(znak == '.') break;
                podaci[j] = znak;
                j++;
                i++;
            }
            wifi.write(NRF24L01P_PIPE_P0, podaci, sirina);
        }
        wifi.write(NRF24L01P_PIPE_P0, "kraj", sirina);
        wait(0.1);
        
        if ( wifi.readable() ) {
            rxDataCnt = wifi.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            pc.puts("\nOsoba2: "); 
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                pc.putc( rxData[i] );
            }
        }
        wait(0.1);
    }
    
}

JEDNOSMJERNI:

// transmiter
#include "mbed.h"
#include "nRF24L01P.h"
#include "string.h"
#define sirina 4
#define MAX 200
nRF24L01P wifi(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);
Serial pc(USBTX, USBRX);
//InterruptIn poruka(PTA13);

char poruka[sirina];
char terminal[MAX];
char tekst[MAX];
int main()
{
    char karakter = '.';
    int i = 0;
  
    wifi.powerUp();
    wifi.setTransferSize(sirina);
    wifi.setRfFrequency();
    wifi.setAirDataRate();
    wifi.setCrcWidth();
    wifi.setRfOutputPower();
    wifi.setTransmitMode();
    wifi.enable();
    
    pc.printf("\nJa: ");
    while(1){
         tekst[i] = pc.getc(); 
         i++;
         
         if(tekst[i] != karakter || i < 200) {
           wifi.setTransmitMode();  
           int j = 0, k = 0;
           
           while(j < i) {
             k = 0;
           while(k < 4) {
            poruka[k] = tekst[j];
            k++;              
            j++;
            }    
            wifi.write(NRF24L01P_PIPE_P0, poruka, sirina);
            } 
             
            tekst[0] = 0;
            i = 0;
        }      
    }   
}

// receiver
#include "mbed.h"
#include "nRF24L01P.h"
#include "string.h"
#define sirina 4
#define MAX 200

nRF24L01P wifi(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);
Serial pc(USBTX, USBRX);

char poruka[sirina];
int rxDataCnt = 0;

int main()
{ 
    wifi.powerUp();
    wifi.setTransferSize(sirina);
    wifi.setRfFrequency();
    wifi.setAirDataRate();
    wifi.setCrcWidth();
    wifi.setRfOutputPower();
    
    wifi.setTransmitMode();
    wifi.enable();
    
    while(1){
        if ( wifi.readable() ) {
            rxDataCnt = wifi.read( NRF24L01P_PIPE_P0, poruka, sirina);
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                pc.putc( poruka[i] );
            }
        }
    }   
}