#include "mbed.h"
char lookup[17] = { 0x40, 0x79, 0x24, 0x30, 0x19, 0x12, 0x02, 0x78, 0x00, 0x10, 0x20, 0x03, 0x46, 0x21, 0x04, 0x09, 0x01};
DigitalOut displays[3] = { dp23, dp24, dp25 };
DigitalOut dec_p = dp4;

// Mapiranja su:
// A - dp26 (bit 0)
// B - dp27 (bit 1)
// C - dp5 (bit 2)
// D - dp6 (bit 3)
// E - dp28 (bit 4)
// F - dp1 (bit 5)
// G - dp2 (bit 6)

BusOut segments (dp26, dp27, dp5, dp6, dp28, dp1, dp2);
/*
* Funkcija treba pisati na segment displaya, argumenti su:
* index - kaze na koji display treba pisati (moguce vrijednosti su 2 do 4)
* value - vrijednost koja se treba zapisati (moguce vrijednosti su cifre od 0 do 9)
* decimal_point - vrijednost koja kaze da li treba decimalnu tacku osvijetliti (moguce vrijednosti su
0 ili 1; 0 - iskljuceno, 1 - ukljuceno)
*/
void write_segment(int index, int value, int decimal_point)
{
// Aktiviramo odgovarajuci display
// D2 je spojen na dp23
// D3 je spojen na dp24
// D4 je spojen na dp25
switch (index)
{
case 2:
displays[0] = 0;
displays[1] = 1;
displays[2] = 1;
break;
case 3:
displays[0]= 1;
displays[1] = 0;
displays[2]  = 1;
break;
case 4:
displays[2]  = 1;
displays[2]  = 1;
displays[2]  = 0;
break;
}

// Preslikavanje vrijednosti u kod
value = lookup[value];
segments = value;

// DP je spojen na dp4
dec_p = decimal_point & (1 << 0);
}
int main()
{
// Varijable koje ce cuvati sekunde i milisekunde
long seconds = 0, millis = 0;
// Varijabla koja ce reci koji display je trenutno aktivan (ima vrijednosti od 2 do 4)
int index = 2;
// Vrijednosti na pojedinim displayjima:
int d2 = 0, d3 = 0, d4 = 0;
// Ako je onih 2 sekunde na pocetku isteklo...
int elapsed = 0;
// Ako je zavrseno brojanje
int finished = 0;
while (true)
{
// Pisanje cifara na display
switch (index)
{
case 2:
write_segment(index, d2, 0);
break;
case 3:
// Ovaj display mora ukljuciti decimalnu tacku
write_segment(index, d3, 1);
break;
case 4:
write_segment(index, d4, 0);
break;
}
// 1 ms cekanje
// Ako je pauza izmedju pojedinih pisanja 1ms to znaci da je za 3 displaya potrebno 3ms
// Sto ispadne 1s / 3ms = 333.33 osvjezavanja u sekundi
wait(0.001);
millis++;
if (millis == 1000)
{
seconds++;
millis = 0;
}
// Startno vrijeme od 2 sekunde proslo
if ((seconds == 2) && (millis == 0))
{
elapsed = 1;
}
// 14 radi 2 sekunde startanja
if ((seconds == 14) && (millis == 300))
{
finished = 1;
}
// Da se ne sracunaju nove vrijednosti
if ((elapsed == 0) || (finished == 1))
continue;
// Cupamo pojedine cifre iz varijabli
// (moramo one 2 sekunde starta odbiti)
d2 = (seconds - 2) / 10;
d3 = (seconds - 2) % 10;
d4 = millis / 100;
// Prelazimo na iduci display
index++;
if (index == 5)
index = 2;
}
return 0;
}
