#include "mbed.h"
#include "N5110.h"
 
//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);
//Deklaracija LCD objekta
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
 
//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);

void baklava(int x, int y)
{
    lcd.clear();
    lcd.setPixel(x,y);
    lcd.setPixel(x+1, y);
    lcd.setPixel(x+2, y);
    lcd.setPixel(x-1, y);
    lcd.setPixel(x-2, y);
    lcd.setPixel(x, y+1);
    lcd.setPixel(x, y+2);
    lcd.setPixel(x, y-1);
    lcd.setPixel(x,y-2);
    lcd.setPixel(x+1,y+1);
    lcd.setPixel(x-1,y+1);
    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x+1,y-1);
    lcd.refresh();
}

void viljuska(int x, int y)
{
    lcd.setPixel(x+6,y+1);
    lcd.setPixel(x+5,y+2);
    lcd.setPixel(x+4,y+3);
    lcd.setPixel(x+5,y+4);
    lcd.setPixel(x+3,y+3);
    lcd.setPixel(x+2,y+4);
    lcd.setPixel(x+4,y+5);
    lcd.setPixel(x+1,y+5);
    lcd.setPixel(x+3,y+6);
    lcd.refresh();
}

int main()
{
    enable=1;
 
    // inicijalizacija displeja
    lcd.init();
    lcd.setXYAddress(0,0);
    int x=0, y=0;
    baklava(x,y);
    int i=0;
    bool krecex=false, krecey=false;  
    int niz[10] = {4,5,6,7,8,9,10,11,12,13};
    while(1)
    {
        if (VRx<1.0/3.0) 
        {   
            if(x>3)
            {
            krecex = true;
            x=x-1;
            }
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        else if(VRx<2.0/3.0)
        {
            krecex = false;
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        else
        {
            if(x<80)
            {
            krecex=true;
            x=x+1;
            }
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        if (VRy<1.0/3.0) 
        {
            if(y>3){
                krecey = true;
            y=y-1;
            }
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        else if(VRy<2.0/3.0)
        {
            krecey=false;
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        else
        {
            if(y<45)
            {
                krecey=true;
            y=y+1;
            }
            baklava(x,y);
            viljuska(x+niz[i], y+niz[i]);
        }
        bool krece=krecex||krecey;
        if(krece && i<9) i++;
        else if(krece==false && i>0)i--;
        wait_ms(100);
    }
}
    