#include "mbed.h"
#include <ctype.h>
#include "TSISensor.h"

PwmOut led[3] = {LED1, LED2, LED3};

Serial pc(USBTX, USBRX); // tx, rx
Ticker t;

TSISensor tsi;

void upaliDiodu(char c)
{
    char prva = pc.getc(), druga = pc.getc();
    int jacina = (prva - '0')*10 + druga - '0';
    led[0] = 1.0;
    led[1] = 1.0;
    led[2] = 1.0;
    if(c=='R')
    led[0]=1.0-jacina/100.0;
    else if(c=='G')
    led[1]=1.0-jacina/100.0;
    else if(c=='B')
    led[2]=1.0-jacina/100.0;
}

void ispisiSenzor()
{
    printf("TSI: %.2f\n", tsi.readPercentage());
}

void ocitaj()
{
    char c = pc.getc();
    if(c=='R' || c=='G' || c=='B') 
    upaliDiodu(c);
    if(c=='P') t.attach(ispisiSenzor, 1.0);
    if(c=='Z') t.detach();
}

int main() {
    led[0]=1.0; led[1]=1.0; led[2]=1.0; 
    pc.attach(ocitaj);
    while(1);
}
