#include "mbed.h"
 
DigitalOut myled(LED1);
 
BusOut display(dp26, dp27, dp5, dp6, dp28, dp1, dp2);
DigitalOut point(dp4);
int numbers[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
int chars[6]={0x08,0x60,0x31,0x42,0x30,0x38};
BusOut digits(dp23,dp24,dp25);
AnalogIn ain(dp9);
 
void showDisplayChar(char input)
{
    if(input>='0' && input <= '9')
    {
        display=numbers[input-'0'];
    }
    else if(input>='a' && input <='f')
    {
        display=numbers[input - 'a'];
    }
    else
    display=0x7f;
}
 
void showDisplay(int input)
{
    if(input>=0 && input<=9)
        display=numbers[input];
    else
        display=0x7f;
}
 
void showValue(float value)
{
    int third=(value-int(value))*10;
    int second=int(value)%10;
    int first=int(value)/10;
    
    digits=7;
    showDisplay(first);
    digits=6;//bilo  = 1
    wait_ms(1);
    
    digits=7;    
    showDisplay(second);    
    digits=5;
    point=0;
    wait_ms(1);
    point=1;
    
    digits=7;
    showDisplay(third);
    digits=3;//bilo = 4
    wait_ms(1);
    digits=0;  
}
 
Timer t;
 
int main() {
    //Procedura pri paljnenju programa, uključi sve cifre displeja i prikaže 0 na njima
    digits=0;
    display=0x40;
    //
    
    while(1) {
        showValue(ain * 3.3); // ain daje realnu vrijednost između 0.0 i 1.0, potrebno je to pomnožiti sa 3.3 (napon napajanja) da nam se prikaže stvarna vrijednsot napona 
    }
}