#include "mbed.h"
#include "sMotor.h"
 
Serial pc(USBTX, USBRX);
sMotor motor (dp13, dp11, dp10, dp9);
 
int step_speed = 1200;
//step(brojKoraka, smjer, step_speed);
const int brojKoraka = 512; //512 == 360 stepeni => zeljeniUgao! -> n = 360/zeljeniUgao -> step(brojKoraka/n , ... , ...);
int orjentacija = 0;
bool ukljucen = false;

 
int main()
{
    pc.printf("1 - Proizvoljan polozaj \n2 - Promjena smjera kretanja \n3 - Promjena brzine kretanja \n4 - Start/stop \n");
 
    while(1) {
        char c(0);
        if(pc.readable()) {
            c = pc.getc();
            //proizvoljan polozaj
            if(c == '1') {
                int zeljeniUgao(0);
                bool trigger = false;
                pc.printf("\nUnesite polozaj motora [0 - 360] : ");
                pc.scanf("%d", &zeljeniUgao);
                if(zeljeniUgao < 0 || zeljeniUgao > 360) {
                    pc.printf("Ugao nije ispravno unesen!\n");
                    trigger = true;
                }
                if(zeljeniUgao != 0 && !trigger) {
                    double n = 360. / zeljeniUgao; //broj koraka za koliko da se okrene; prvi param. u funkc step(a,b,c);
                        motor.step((int)(brojKoraka / n), orjentacija, step_speed);
                }
            }
            //orjentacija okretanja
            if(c == '2') {
                orjentacija = 1 - orjentacija;
                while(pc.getc()!='4')
                    motor.step(brojKoraka, orjentacija, step_speed);
            }
            //brzina kretanja
            if(c == '3') {
                pc.printf("\nUnesite zeljenu brzinu : ");
                pc.scanf("%d", &step_speed);
                while(pc.getc()!='4')
                    motor.step(brojKoraka, orjentacija, step_speed);
            }
            //start/stop
            if(c == '4') {
                ukljucen = !ukljucen;
                if(ukljucen){
                    pc.printf("\nMotor je UKLJUCEN!\n");
                    
                     motor.step(brojKoraka, orjentacija, step_speed);}
                else
                {
                    pc.printf("\nMotor je ISKLJUCEN!\n");
                
                    motor.step(brojKoraka, orjentacija, 825);}
                }
            }
 
        }
    }
