#include "mbed.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1) 

Serial pc(USBTX, USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
PwmOut crvena(PTB18), zelena(PTB19), plava(PTD1);
Ticker prikaz;

void PrikaziNaTerminalX()
{
    pc.printf("Po X osi: %f \n", acc.getAccX());
}

void PrikaziNaTerminalY()
{
    pc.printf("Po Y osi: %f \n", acc.getAccY());
}

void PrikaziNaTerminalZ()
{
    pc.printf("Po Z osi: %f \n", acc.getAccZ());
}

void PrikaziNaTerminalKoordinate()
{
    pc.printf("{x,y,z} = {%f,%f,%f} \n",acc.getAccX(),acc.getAccY(), acc.getAccZ());
}
 
int main()
{
    crvena = 1.;
    zelena = 1.;
    plava = 1.;
 
    while(true)
    {
        char komanda = pc.getc();
 
        if(komanda == 'X')prikaz.attach(PrikaziNaTerminalX, .5);
        else if(komanda == 'Y') prikaz.attach(PrikaziNaTerminalY, .5);
        else if(komanda == 'Z') prikaz.attach(PrikaziNaTerminalZ, .5);
        else if(komanda == 'A') prikaz.attach(PrikaziNaTerminalKoordinate, .5);
        else if(komanda == 'S') prikaz.detach();
        crvena = 1.0 - abs(acc.getAccX());
        zelena = 1.0 - abs(acc.getAccY());
        plava = 1.0 - abs(acc.getAccZ());
        wait(0.1);
    }
 
    return 0;
}