#include "mbed.h"
#include "TSISensor.h"
#include <ctype.h>

Serial pc(USBTX, USBRX);
TSISensor tsi;
Ticker t;
PwmOut led[3] = {LED1, LED2, LED3};

void dioda(char c)
{
    char cnum1 = pc.getc();
    char cnum2 = pc.getc();
    int brightness;
    if ((!isdigit(cnum1))||(!isdigit(cnum1)))return;
    brightness = (cnum1-'0')*10 + (cnum2-'0');
    for(int i=0; i<3; i++) led[i]=1.0;
    switch(c)
    {
    case 'R':
        led[0]=1.0-brightness/100.0;
        break;
    case 'G':
        led[1]=1.0-brightness/100.0;
        break;
    case 'B':
        led[2]=1.0-brightness/100.0;
        break;
    }
}

void write(){
    pc.printf("TSI: %.2f\n",tsi.readPercentage());
    }

void pcread()
{
    if (!pc.readable()) return;
    char c = pc.getc();
    if(c=='R'||c=='G'||c=='B') dioda(c);
    else if (c=='P') t.attach(write,1.0);
    else if (c=='Z') t.detach();
    else return;
}

int main()
{
    for(int i=0; i<3; i++) led[i]=1.0;
    pc.attach(pcread);
    while(1);
}