#include "mbed.h"
#include "N5110.h"
 
//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);
//Deklaracija LCD objekta
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
 
//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);
 
void baklava(int x, int y)
{
    lcd.clear();
    lcd.setPixel(x,y);
    lcd.setPixel(x+1, y);
    lcd.setPixel(x+2, y);
    lcd.setPixel(x-1, y);
    lcd.setPixel(x-2, y);
    lcd.setPixel(x, y+1);
    lcd.setPixel(x, y+2);
    lcd.setPixel(x, y-1);
    lcd.setPixel(x,y-2);
    lcd.setPixel(x+1,y+1);
    lcd.setPixel(x-1,y+1);
    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x+1,y-1);
    lcd.refresh();
}
 
void viljuska(int x, int y)
{
   
    lcd.setPixel(x+7,y+1);
    lcd.setPixel(x+5,y+2);
    lcd.setPixel(x+4,y+3);
    lcd.setPixel(x+5,y+4);
    lcd.setPixel(x+3,y+3);
    lcd.setPixel(x+2,y+4);
    lcd.setPixel(x+4,y+5);
    lcd.setPixel(x+1,y+5);
    lcd.setPixel(x+3,y+6);
    lcd.refresh();
}
 
int main()
{
    enable=1;
    lcd.init();
    lcd.setXYAddress(0,0);
    int x=0, y=0;
    baklava(x+3,y+3);
    int i=0;
    bool pomjeriX=false, pomjeriY=false;  
   int niz[20] = {4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};
    while(1)
    {
        if (VRx<1.0/3.0) 
        {   
            if(x>3)
            {
                pomjeriX = true;
                x=x-1;
            }
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        else if(VRx<2.0/3.0)
        {
            pomjeriX = false;
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        else
        {
            if(x<80)
            {
                pomjeriX=true;
                x=x+1;
            }
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        if (VRy<1.0/3.0) 
        {
            if(y>3)
            {
                pomjeriY = true;
                y=y-1;
            }
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        else if(VRy<2.0/3.0)
        {
            pomjeriY=false;
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        else
        {
            
            if(y<45)
            {
                pomjeriY=true;
                y=y+1;
            }
            baklava(x+niz[i],y+niz[i]);
            viljuska(x,y);
        }
        bool kretaoSe=false;
        if(pomjeriX==true || pomjeriY==true) kretaoSe=true;
        if(kretaoSe && i<19) i++;
        else if (kretaoSe==false && i>0) i--;
        wait_ms(100);
    }
}