#include "mbed.h"
int numbers[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
int digits[3]={6,5,3};

BusOut enable_digits(dp23,dp24,dp25);
BusOut display(dp26, dp27, dp5, dp6, dp28, dp4, dp18);

DigitalOut enable_point(dp17);
DigitalOut enable(dp14);

InterruptIn taster1(dp1);
InterruptIn taster2(dp2);

Timer debounce1;
Timer debounce2;
Ticker stopwatch;

bool stop=true;

float value=0;

void startStop()
{
    if(stop)
    {
        if(debounce1.read_ms()>200)
        {
            stop=!stop;
            debounce1.reset();
        }
    }
    else if(!stop)
    {
        if(debounce1.read_ms()>200)
        {
            stop=!stop;
            debounce1.reset();
        }
    }
}

void restart()
{
    if(debounce2.read_ms()>200)
    {
        stop=true;
        value=0;
        debounce2.reset();
    }
}

void enableDigit(int input)
{
    if(input>=0 && input<=9)
        display=numbers[input];
    else
        display=0x7f;
}

int digit=0;


void showDigit(int digit,int number, int point=1)
{
    enableDigit(number);
    if(digit==1)
        point=0;
    enable_point=point;
    enable_digits=digits[digit];

}

int i=0;
void displayValue()
{   
    enable_point=1;
    enable_digits=7; 
    
    int third=int(value*10)%10;
    int second=int(value)%10;
    int first=int(value)/10;
    
    int niz[3]={first,second,third};

    showDigit(i,niz[i]); 
    
    if(value<=99.9&&!stop)
        value+=0.005;
        
    i=(i+1)%3;
    
}
 
int main() {
    stopwatch.attach(displayValue,0.005);
    debounce1.start();
    debounce2.start();
    taster1.rise(startStop);
    taster2.rise(restart);
    while(1) {
    }
}
 