#include "mbed.h"
char lookup[17] = { 0x40, 0x79, 0x24, 0x30, 0x19, 0x12, 0x02, 0x78, 0x00, 0x10, 0x20, 0x03, 0x46, 0x21, 0x04, 0x09, 0x01};
DigitalOut displays[3] = {dp25, dp24, dp23 };
DigitalOut dec_p = dp17;
int index(2);// Varijabla koja ce reci koji display je trenutno aktivan (ima vrijednosti od 2 do 4)
 InterruptIn power(dp1), reset(dp2); //tasteri

int value(0);//aktuelna vrijednost na display-u
int d2 = 0, d3 = 0, d4 = 0;// Vrijednosti na pojedinim displayjima
float timing(0);
Ticker turnDisplayOn;
Timer timer, debounce1, debounce2;
bool running(false);
 
// Mapiranja su:
// A - dp26 (bit 0)
// B - dp27 (bit 1)
// C - dp5 (bit 2)
// D - dp6 (bit 3)
// E - dp28 (bit 4)
// F - dp1 (bit 5)
// G - dp2 (bit 6)
 
BusOut segments (dp26, dp27, dp5, dp6, dp28, dp4, dp18);
 
 
void writeSegment()// Pisanje cifara na display
{
    timing = timer.read();
    // Cupamo pojedine cifre iz value
    d4 = int(timing / 10);
    d3 = int(timing)  % 10;
    d2 = int(timing * 10) % 10;
 
switch (index)
{
case 2:
dec_p = 1;
value = lookup[d2];
segments = value;
displays[0] = 0;
displays[1] = 1;
displays[2] = 1;
break;
case 3:
dec_p = 0;
value = lookup[d3];
segments = value;
displays[0]= 1;
displays[1] = 0;
displays[2]  = 1;
break;
case 4:
dec_p = 1;
value = lookup[d4];
segments = value;
displays[0]  = 1;
displays[1]  = 1;
displays[2]  = 0;
break;
}
 index++;// Prelazimo na iduci display
if (index == 5)
index = 2;
}
 
void checkOnOff()
{
         if(debounce1.read_ms() > 200)
         {
              if(running) timer.stop();
              else timer.start();
              running = !running;
              
        }   
         debounce1.reset();
}
 
void checkReset()
{
 
         if(debounce2.read_ms() > 200)
         {  
         
            running = false;
            timer.reset();
            timer.stop();
         }  
         debounce2.reset(); 
           
}

int main()
{
    timer.reset();
    debounce1.start();
    debounce2.start();
    power.rise(&checkOnOff);
    reset.rise(&checkReset);
    turnDisplayOn.attach(&writeSegment, 0.001);
    while(1)
    {}
    return 0;
}
 