#include "mbed.h"
 
using namespace std;
 
BusOut segments(dp2, dp1, dp28, dp6, dp5, dp27, dp26);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp4);
AnalogIn voltage(dp9);
 
 
int predefined_segments[10] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 0x24, 0x20, 0x0f, 0x00, 0x04};
 
void display(float vtg)
{
    
    int digits[3] = {(int)(vtg / 100) % 10, (int)(vtg / 10) % 10, (int)(vtg) % 10};
    for(int i = 1; i <= 4; i = i * 2) {
        segments = predefined_segments[digits[i / 2]];
        digit = ~i;
        decimal_point = (i == 1) ? 0 : 1;
        wait_ms(1);
    }
}
 
int main()
{
    while(1) {
        display(voltage * 3.3 *100);
    }
}