#include "mbed.h"
#define R 10000
 
BusOut display(dp26, dp27, dp5, dp6, dp28, dp1, dp2);// elementi 7segmentne cifre u rasporedu - g f e b c d a
BusOut digits(dp23,dp24,dp25);
DigitalOut point(dp4);//Decimalna tačka
AnalogIn ain(dp9);
 
 
int numbers[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};//Hexadecimalne vrijednosti stanja 7segmentne cifre, prvi element je broj 0 na cifri, drugi element je broj 1 na cifri itd.
 
//Funkcija za uključivanje odgovarajućih segmenata 7segmentne cifre 
void showDigit(int input)
{
    if(input>=0 && input<=9)
        display=numbers[input];
    else
        display=0x7f;
}
 
void showValue(float value)
{
    int third=(value-int(value))*10;
    int second=int(value)%10;
    int first=int(value)/10;
    
    digits=7;
    showDigit(first);
    digits=6;
    wait_ms(1);
    
    digits=7;    
    showDigit(second);    
    digits=5;
    point=0;
    wait_ms(1);
    point=1;
    
    digits=7;
    showDigit(third);
    digits=3;
    wait_ms(1);
    digits=0;  
}
 
float giveMinVoltage()
{
    return (3.3/(R+1000))*1000;
}
 
float giveMaxVoltage()
{
    return (3.3/(R+12000))*1000;
}
 
float giveRatio()
{
    float maxVoltage=2.2;
    float minVoltage=0.8;
    float diffVoltage=maxVoltage-minVoltage;
    float inputVoltage=ain*3.3;
    
    if(inputVoltage>=minVoltage && inputVoltage<=maxVoltage)
        return 1-(inputVoltage-minVoltage)/diffVoltage;
    return 0; 
}

int main() {
    float ratio=0;
    float input=0;
    int i=0;
    while(1) {
        if(i%100==0)
        {
            input=ain*3.3; 
            i=1;
        }      
        if(input>=0.8 && input<=2.2)      
            ratio=giveRatio();
        showValue(ratio*100);
        i++;
    }
}