#include "mbed.h"

DigitalOut myled(LED1);

BusOut display(dp26, dp27, dp5, dp6, dp28, dp1, dp2);
DigitalOut point(dp4);
int numbers[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
int chars[6]={0x08,0x60,0x31,0x42,0x30,0x38};
BusOut digits(dp23,dp24,dp25);


DigitalOut rows[4]={dp16,dp15,dp17,dp18};
DigitalIn  columns[4]={dp9,dp10,dp11,dp13};


void showDisplay(int input)
{
    if(input>=0 && input<=9)
        display=numbers[input];
    else
        display=0x7f;
}

void stopwatch(float value)
{
    int third=(value-int(value))*10;
    int second=int(value)%10;
    int first=int(value)/10;
    
    digits=6;//bilo  = 1
    showDisplay(first);
    wait_ms(1);
    
    digits=7;
    
    showDisplay(second);    
    digits=5;
    point=0;
    wait_ms(1);
    
    digits=7;
    showDisplay(third);
    digits=3;//bilo = 4
    wait_ms(1);
    digits=0;  
}

Timer t;

bool press(DigitalIn button)
{
    if(!button)
        return false;
    int counter=0;
    for(int i=0;i<200;i++)
        if(button) counter++;
    if(counter>=120) return true;
    return false;
}
int values[3]={0,0,0};
int counter=0;


void displayNumber(char value)
{
 
    if(value == 'c')
    {
        values[0]=0;
        values[1]=1;
        values[2]=0;
        counter=0;
    }
    else if (counter==0 && value == '0')
    { }
    else if(counter<3 && value>='1' &&  value<='9')
    {
        values[2]=values[1];
        values[1]=values[0];
        values[0]=value-'0';
        counter++;
    }
    
    for(int i=1;i<=4;i=i*2)
    {
        display=numbers[values[2-i/2]];
        digits=7-i;
        wait_ms(1);
        digits=7;
    }
} 

char giveChar()
{
    char value=0;
    for(int i=0;i<4;i++)
    {
        rows[i]=1;
        for(int j=0;j<4;j++)
        {
            if( i<3 && j<3 && press(columns[j]) )
                value= '1'+(i*3+j);
                
            if(j==3 && press(columns[j]) )
                value= 'a'+i;
            if(i==3 && press(columns[j]) )
            {
                if(j==0)
                    value= '*';
                if(j==1)
                    value= '0';
                if(j==2)
                    value='#';
            }
        }
        rows[i]=0;
        if(value!=0)
            break;
    }            
    return value;   
}

int main() {
    digits=6;
    display=0x40;
    while(1)
    {
        displayNumber(giveChar());
    }
}
