#include "mbed.h"
#include "N5110.h"

#include <string>

#define DELETE_CHAR '3'
#define BACKSPACE_CHAR '2'
#define ENTER_CHAR '1'

#define ROW_NUM 5

#define Y_DISPLACEMENT 1
#define X_DISPLACEMENT 1

//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
Serial pc(USBTX, USBRX);

DigitalOut enable(dp14);

string rijec = "";
string past_rijec = "";

void display_rijec() {
    lcd.clear();
    lcd.setXYAddress(0, 0);

    int x = 0, y = 0;
    for(int i = 0; i < rijec.length(); i++) {
        if(rijec[i] == ENTER_CHAR)
            lcd.setXYAddress(0, (y + Y_DISPLACEMENT) % ROW_NUM);
        else {
            lcd.printChar(rijec[i]);
            x += X_DISPLACEMENT;
        }
    }

    lcd.refresh();
}

int main() {
    
    enable = 1;
    lcd.init();
    lcd.setXYAddress(0, 0);
    char trenutni;
    
    while(true) {
        past_rijec = rijec;
        if(pc.readable()) {
            trenutni = pc.getc();
            if(trenutni == DELETE_CHAR)
                rijec = "";
            else if(trenutni == BACKSPACE_CHAR)
                rijec = rijec.substr(0, rijec.length() - 1);
            else
                rijec.push_back(trenutni); 
        }   
        
        display_rijec();
    }

    return 0; // redundant
}
