#include "mbed.h"
#include "sMotor.h"


Serial pc(USBTX, USBRX);
sMotor motor(p9, p10, p11, p12); // creates new stepper motor: IN1, IN2, IN3, IN4

int step_speed = 1200 ; // set default motor speed
int numstep = 512 ; // defines full turn of 360 degree
int direction = 0; //0 for right, 1 for left
bool on = true; //if the motor is on/off

int main() {

    // Screen Menu
    printf("Default Speed: %d, press: \n\r",step_speed);
    printf("1- to choose random angle to set new motor state\n\r");
    printf("2- to change the motor direction\n\r");
    printf("3- to change the rotation speed\n\r");
    printf("4- to start/stop the motor\n\r");

    while (1) {

        if (pc.readable()) { // checks for serial

            if (pc.getc()=='1')
            {
                if(on)
                {
                int angle;
                printf("Specify the angle to move the motor from current position: \n\r");
                pc.scanf("%d", &angle);
                if ( angle > 0 )
                motor.step(numstep / 360.0 * (angle % 360), direction, step_speed); // number of steps, direction, speed
                else
                motor.step(numstep / 360.0 * (angle % 360), 1 - direction, step_speed); // number of steps, direction, speed
                }
                else
                printf("The motor is off. Turn it on first. \n\r");
            } 
                
            if (pc.getc()=='2')
            {
                direction = 1 - direction;
            }
            if (pc.getc()=='3')
            {
                printf("Current Speed: %d\n\r", step_speed);
                printf("New speed: \n\r");
                pc.scanf("%d",&step_speed); // sets new speed
            }

            if (pc.getc()=='4')
            {
                on = !on;
                if(on)
                printf("The motor is now on.\n\r");
                else
                printf("The motor is now off. \n\r");
                }
        }
    }
}
