#include "mbed.h"
#include "N5110.h"

Serial pc(USBTX, USBRX);
DigitalOut enable(dp14);
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
DigitalIn   SW(dp9); 
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
Ticker t;
int x=0, y=0;
char a;
void NacrtajCursor(int x, int y) {
    lcd.setPixel(x-1,y+1);
    lcd.setPixel(x,y+1);
    lcd.setPixel(x+1,y+1);
    lcd.setPixel(x-1,y);
    lcd.setPixel(x+1,y);
    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x,y-1);
    lcd.setPixel(x+1,y-1);
}

void ObrisiCursor(int x, int y) {
    lcd.clearPixel(x-1,y+1);
    lcd.clearPixel(x,y+1);
    lcd.clearPixel(x+1,y+1);
    lcd.clearPixel(x-1,y);
    lcd.clearPixel(x+1,y);
    lcd.clearPixel(x-1,y-1);
    lcd.clearPixel(x,y-1);
    lcd.clearPixel(x+1,y-1); 
}
void trepci()
{
    NacrtajCursor(x,y);
    ObrisiCursor(x,y);
}

int main() {
    enable = 1;
    pc.baud(115200);
    lcd.init();
    lcd.setXYAddress(0,0);
    for(int i=0; i<84; i++) {
       for(int j=0; j<48; j++) {
           a= pc.getc();
           if (a=='1') lcd.setPixel(i,j); 
           else lcd.clearPixel(i,j); 
          }
       }
    lcd.refresh();
 while(1) {
   
    if(VRx < 1.0/3.0) { 
        x-=2;       
     }
    else if(VRx > 2.0/3.0) {
        x+=2;
    }
    if(VRy < 1.0/3.0) {
        y-=2;
    }
    else if(VRy > 2.0/3.0){
        y+=2;
    }
    t.attach(&trepci, 0.1);
    lcd.refresh();
    }
}
