#include "mbed.h"
#include "N5110.h"
#include "math.h"

#define MAXWIDTH 84
#define MAXHEIGHT 48

Timer deb;
DigitalOut enable(dp14);
InterruptIn taster(dp1);
 int X=0;int Y=0;
 int xpoc=90,ypoc=90,x,y;
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
DigitalIn SW(dp9);
DigitalIn mytaster (dp1);

N5110 lcd (dp4, dp24, dp23, dp25, dp2, dp6, dp18);

void setCursor (int x, int y)
{ 
    for (int i=x; i<=x+2; i++)
    {
        for (int j=y; j<=y+2; j++)
        {
            lcd.setPixel(i, j);
            lcd.refresh();
         }
    }
}

void obrisi (int x, int y)
{ 
    for (int i=x; i<=x+2; i++)
    {
        for (int j=y; j<=y+2; j++)
        {
            lcd.clearPixel(i, j);
            lcd.refresh();
         }
    }
}

void pomjeriDesno (int &x, int &y)
{
    if (x>75)
    {
        obrisi(x, y);
        x=0;
        
        setCursor(x, y);
    }
    else {
    obrisi(x, y);
    x=x+1;
    setCursor(x, y);
    }
}

void pomjeriLijevo (int &x, int &y)
{
    if (x<5)
    {
        obrisi(x, y); 
        x=75;  
        setCursor(x, y);
    }
    else {
    obrisi(x, y);
    x=x-1;
    setCursor(x, y);
    }
}

void pomjeriGore (int &x, int &y)
{
    if (y>43)
    {
        obrisi(x, y); 
        y=0;  
        setCursor(x, y);
    }
    else {
    obrisi(x, y);
    y=y+1;
    setCursor(x, y);
    }
}

void pomjeriDole (int &x, int &y)
{
    if (y<5)
    {
        obrisi(x, y);
        y=75;   
        setCursor(x, y);
    }
    else {
    obrisi(x, y);
    y=y-1;
    setCursor(x, y);
    }
}

void iscrtajLiniju(int x1, int y1, int x2, int y2)
{
     lcd.setXYAddress(0,0);
  int dx = abs(x2-x1), sx = x1<x2 ? 1 : -1;
  int dy = abs(y2-y1), sy = y1<y2 ? 1 : -1; 
  int err = (dx>dy ? dx : -dy)/2, e2;
  x1=x2; y1=y2;
  for(;;){
    setCursor(x1,y1);
    if (x1==x2 && y1==y2) break;
    e2 = err;
    if (e2 >-dx) { err -= dy; x1 += sx; }
    if (e2 < dy) { err += dx; y1 += sy; }
    }
}

static int nesto =1;
void tacka()
{   
    
    if(deb.read_ms() > 400) 
            if(nesto%2!=0) {xpoc=X; ypoc=Y;nesto++;}
        else{
            x=X; y=Y;
        iscrtajLiniju(xpoc,ypoc,x,y);
        wait(5);
        lcd.clear();
        xpoc=90; ypoc=90; lcd.setXYAddress(0,0); X=0; Y=0; nesto=1;
        }
    
    deb.reset();
}




    

 
int main()
{
    
    enable=1;
     
    SW.mode(PullUp);
    deb.start();

    // inicijalizacija displeja
    lcd.init();
    lcd.setXYAddress(X,Y);
    
    int x1=-1, y1=-1, x2, y2;
     
    setCursor(X,Y);
    while (1)
    {
      if(VRx < 1.0/3.0) pomjeriDesno(X,Y);
      else if(VRx > 2.0/3.0) pomjeriLijevo(X,Y);

      if(VRy < 1.0/3.0) pomjeriGore(X,Y);
      else if(VRy > 2.0/3.0) pomjeriDole(X,Y);
      
      setCursor(xpoc,ypoc);
      if (mytaster) 
      {
          if (x1==-1 && y1==-1)
          {
          x1=X, y1=Y;
          lcd.setXYAddress(X,Y);
          lcd.setPixel(x1, y1);
          }
          else 
          {
              x2=X, y2=Y;
          lcd.setXYAddress(X,Y);
          lcd.setPixel(x2, y2);
          }
        }
      
    }
     
}
  