#include "mbed.h"

BusOut seg(dp18, dp4, dp28, dp6, dp5, dp27, dp26);
BusOut dig(dp23, dp24, dp25);
DigitalOut decPoint(dp17);
InterruptIn tast1(dp1);
InterruptIn tast2(dp2);

Timer timer;
Timer db1;
Timer db2;
Ticker tiker; // za reload
 
int redniCifra;
int ispisCifra;
int prvaCifra, drugaCifra, trecaCifra;
int predefSeg[10] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 0x24, 0x20, 0x0f, 0x00, 0x04};
int chars[6] = {0x08, 0x60, 0x31, 0x42, 0x30, 0x38};
bool stoped = true;
 
void reload(){
    redniCifra = 3;
    ispisCifra = predefSeg[prvaCifra];
    redniCifra = 5;
    ispisCifra = predefSeg[drugaCifra];
    redniCifra = 6;
    ispisCifra = predefSeg[trecaCifra];
} 

void prikaz(float trenutno){ // provjeriti 
    int timerCifra[3] = {(int)(trenutno / 10.) % 10, (int)(trenutno) % 10, (int)(trenutno * 10.) % 10};
    for(int i = 1; i <= 4; i = i * 2){
        dig = ~i;
        seg = predefSeg[timerCifra[i / 2] ];
        decPoint = (i == 2) ? 0 : 1;
        tiker.attach_us(&reload, 1000);
    }
}

 
void start(){
    if(db1.read_ms() > 200) {
        if(stoped) {
            timer.start();
            stoped = false;
        } else {
            timer.stop();
            stoped = true;
        }
        db1.reset();
    }
 
}
 
void reset(){
    if(db2.read_ms() > 200){
        timer.reset();
        timer.stop();
        stoped = true;
        prikaz(0.00);
        db2.reset();
    }
}
 
int main()
{
    db1.start();
    db2.start();
    tast1.rise(&start);
    tast2.rise(&reset);
    while(1){
        prikaz(timer.read());
    }
}
