#include "mbed.h"
#include "TSISensor.h"

#include <string>

Serial pc(USBTX, USBRX);
PwmOut red(LED_RED), green(LED_GREEN),blue(LED_BLUE);

TSISensor tsi;

Ticker status;

string rijec = "";
bool mjerenje = false;

bool is_digit(char c) {
    return c >= '0' && c <= '9';
}



void show_status() {
    if(mjerenje)
        pc.printf("%f\n", tsi.readPercentage());
        
        if(rijec.length() == 1 && rijec[0] == 'P') {
            mjerenje = true;
        } else if(rijec.length() == 1 && rijec[0] == 'Z') {
            mjerenje = false;
        }
}

int main() {
    
    red = 1.;
    green = 1.;
    blue = 1.;
    status.attach(show_status, 1.);
    
    while(true) {
        rijec.push_back(pc.getc());
        if(rijec.length() == 3) {
            if(!is_digit(rijec[1]) || !is_digit(rijec[2]))
                rijec="";
            float intenzitet = ((rijec[2] - '0') + 10 * (rijec[1] - '0')) / 100.;
            switch(rijec[0]) {
                case 'R':
                    red = 1 - intenzitet;
                    rijec = "";
                break;

                case 'G':
                    green = 1 - intenzitet;
                    rijec = "";
                break;

                case 'B':
                    blue = 1 - intenzitet;
                    rijec = "";
                break;

                default:
                    rijec="";
            }
        } else if(rijec.length() == 1 && rijec[0] == 'P') {
            mjerenje = true;
        } else if(rijec.length() == 1 && rijec[0] == 'Z') {
            mjerenje = false;
        }
    }

    return 0; 
}