#include "mbed.h"
#include "TSISensor.h"
 
PwmOut red(LED_RED);
PwmOut green(LED_GREEN);
PwmOut blue(LED_BLUE);
 
Serial pc(USBTX, USBRX);
TSISensor tsi;
 
Ticker tick;
 
void ispisi()
{
    pc.printf("Vrijednost TSI senzora: %g %%\n\r", tsi.readPercentage()*100);
 
}
 
int main()
{
    red = 1;
    green = 1;
    blue = 1;  
 
    while(1)
    {
        char c = pc.getc();
        if(c == 'P') tick.attach(&ispisi, 1);
        else if(c=='Z') tick.detach();
        else if(c == 'R' || c == 'G' || c == 'B')
        {
            int d((pc.getc() - '0') * 10);
            int j(pc.getc() - '0');
            red = green = blue = 1;
            float intenzitet((d+j)/100.);
            
            if(c == 'R') red = 1 - intenzitet;
            else if(c == 'G') green = 1 - intenzitet;
            else blue = 1 - intenzitet;
        
        }
    }
}