#include "mbed.h"
 
BusOut digits(dp23,dp24,dp25);
BusOut display(dp26, dp27, dp5, dp6, dp28, dp4, dp18);
DigitalOut point(dp17);
int numbers[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
int chars[6]={0x08,0x60,0x31,0x42,0x30,0x38};
bool test=false;
float value=0;

InterruptIn button1(dp1);
InterruptIn button2(dp2);

Timer debounce1;
Timer debounce2;
Ticker stoper;

void play()
{
    if(debounce1.read_ms()>200){
        test=!test;
        debounce1.reset();     
    }
}


void restart()
{
    if(debounce2.read_ms()>200)
    {
        test=false;
        value=0;
        debounce2.reset();
    }
}


void showDigit(int input)
{
    if(input>=0 && input<=9)
        display=numbers[input];
    else
        display=0x7f;
}
 
 
void displayValue()
{
    int third=int(value*10)%10;
    int second=int(value)%10;
    int first=int(value)/10;
    

    showDigit(first);
    digits=6;
    wait_ms(1);
    digits=7;
    
    showDigit(second);    
    digits=5;
    point=0;
    wait_ms(1);
    point=1;
    digits=7;
    
    showDigit(third);
    digits=3;
    wait_ms(1);
    digits=7;
    if(test)
        value+=0.01;  
}

int main() {
    debounce1.start();
    debounce2.start();
    stoper.attach(displayValue,0.01);
    button1.rise(play);
    button2.rise(restart);
    while(1) {
        
    }
}