#include "mbed.h"

#define MAX 255

BusIn kolona (dp9, dp10, dp11, dp13);
BusOut red (dp16, dp15, dp17, dp18);

BusOut myleds (dp23, dp24, dp25, dp26, dp27, dp5, dp6, dp28);

DigitalOut enabled (dp14);

int main() {
  int n = 0;
  enabled = 0;
  myleds = MAX;
  red = 0;
  while(1) {
    red = 8;
    switch(kolona) {
      case 8 :
        myleds = MAX - 1;
        break;
      case 4 :
        myleds = MAX - 2;
        break;
      case 2 :
        myleds = MAX - 4;
        break;
      case 1 :
        myleds = 63;
        break;
      default :
        //myleds = MAX;
        break;
    }
    red = 4;
    switch (kolona) {
      case 8 :
        myleds = MAX - 8;
        break;
      case 4 :
        myleds = MAX - 16;
        break;
      case 2 :
        myleds = MAX - 32;
        break;
      case 1 :
        myleds = 207;
        break;
      default :
        //myleds = MAX;
        break;
    }
    red = 2;
    switch (kolona) {
      case 8 :
        myleds = MAX - 64;
        break;
      case 4 :
        myleds = MAX - 128;
        break;
      case 2 :
        myleds = MAX - 256;
        break;
      case 1 :
        myleds = 243;
        break;
      default :
        //myleds = MAX;
        break;
    }
    red = 1;
    switch (kolona) {
      case 8 :
        while(red == 1 && kolona == 8) {
          myleds = 2^n;
          wait(0.2);
          n--;
          if(n == -1) n = 7;
        }
        break;
      case 4 :
        myleds = 0;
        break;
      case 2 :
        while(red == 1 && kolona == 2) {
          myleds = 2^n;
          wait(0.2);
          n++;
          if(n == 8) n = 0;
        }
        break;
      case 1 :
        myleds = 252;
        break;
      default :
        //myleds = MAX; 
        break;
    }
    
  }
}