#include "mbed.h"
#include "sMotor.h"
 
 
Serial pc(USBTX, USBRX);
sMotor motor(dp9, dp10, dp11, dp13); // creates new stepper motor: IN1, IN2, IN3, IN4
 
int step_speed = 1200 ; // set default motor speed
int numstep = 512 ; // defines full turn of 360 degree
int direction = 0; //0 for right, 1 for left
 
 void screenMenu()
 {
        // Screen Menu
            pc.printf("Default Speed: %d, press: \n\r",step_speed);
            pc.printf("1- to choose random angle to set new motor state\n\r");
            pc.printf("2- to change the motor direction\n\r");
            pc.printf("3- to change the rotation speed\n\r");
            pc.printf("4- to start/stop the motor\n\r");
}
int main() {
    
    screenMenu();
   
    while (1) {
    
        if (pc.readable()) { // checks for serial
            char c (pc.getc());
             if (c == '1')
            {
                
                int angle;
                pc.printf("\nSpecify the angle to move the motor from current position: \n\r");
                pc.scanf("%d", &angle);
                if ( angle > 0 )
                motor.step(numstep / 360 * (angle % 360), direction, step_speed); // number of steps, direction, speed
                else
                motor.step(numstep / 360 * (angle % 360), 1 - direction, step_speed); // number of steps, direction, speed
                
                screenMenu();
            } 
                
            if (c =='2')
            {
                direction = 1 - direction;
                pc.printf("\nDirection is changed.\n");
                screenMenu();
            }
            if ( c =='3')
            {
                pc.printf("\nCurrent Speed: %d\n\r", step_speed);
                pc.printf("\nNew speed: \n\r");
                pc.scanf("%d",&step_speed); // sets new speed
                pc.printf("\nThe speed has been changed.");
                screenMenu();
            }
 
            if (c =='4')
            {
                pc.printf("\nPress 0 to stop the motor: \n\r");
                int korak=10;
                while (!pc.readable() || pc.getc() != '0'){
                motor.step(korak, direction, step_speed);
                korak+=10;}
                wait(2);
                screenMenu();
                }
         
        }
    }
}