#include "mbed.h"
#include "N5110.h"

#define MAXWIDTH 84
#define MAXHEIGHT 48

Timer deb;
DigitalOut enable(dp14);
InterruptIn taster(dp1);
 int X=0;int Y=0;
 int x1=90,y1=90,x2,y2;
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
DigitalIn SW(dp9);

N5110 lcd (dp4, dp24, dp23, dp25, dp2, dp6, dp18);

void cursor(int x, int y)
{
    for(int i=x; i<=x+2; i++)
     for(int j=y; j<=y+2; j++)
    {
        lcd.setPixel(i,j);
        lcd.refresh();
    }
}

void brisi(int x, int y)
{
    for(int i=x; i<=x+2; i++)
     for(int j=y; j<=y+2; j++)
    {
        lcd.clearPixel(i,j);
        lcd.refresh();
    }
}

void Lijevo(int &x, int &y)
{
    if(x>0){
        brisi(x,y);
        x=x-1;
        cursor(x,y);
        
    }
}

void Desno(int &x, int &y)
{
    if(x<81){
        brisi(x,y);
        x=x+1;
        cursor(x,y);
    }
}

void Gore(int &x, int &y)
{
    if(y>0){
        brisi(x,y);
        y=y-1;
        cursor(x,y);
    }
}

void Dolje(int &x, int &y)
{
    if(y<45){
        brisi(x,y);
        y=y+1;
        cursor(x,y);
    }
}
void line(int x0, int y0, int x3, int y3) {
 lcd.setXYAddress(0,0);
  int dx = abs(x3-x0), sx = x0<x3 ? 1 : -1;
  int dy = abs(y3-y0), sy = y0<y3 ? 1 : -1; 
  int err = (dx>dy ? dx : -dy)/2, e2;
  x0=x1; y0=y1;
  for(;;){
    cursor(x0,y0);
    if (x0==x2 && y0==y2) break;
    e2 = err;
    if (e2 >-dx) { err -= dy; x0 += sx; }
    if (e2 < dy) { err += dx; y0 += sy; }
  }
}

static int nesto =1;
void tacka()
{   
    
    if(deb.read_ms() > 400) 
            if(nesto%2!=0) {x1=X; y1=Y;nesto++;}
        else{
            x2=X; y2=Y;
          line(x1,y1,x2,y2);
        wait(5);
        lcd.clear();
        x1=90; y1=90; lcd.setXYAddress(0,0); X=0; Y=0; nesto=1;
        }
    
    deb.reset();
}

int main(){
  
  enable = 1;
  SW.mode(PullUp);
  deb.start();
  lcd.init();
 
  
  lcd.setXYAddress(X,Y);
   cursor(X,Y);
  taster.rise(&tacka);
  while(1){
      if(VRx < 1.0/3.0) Lijevo(X,Y);
      else if(VRx > 2.0/3.0) Desno(X,Y);

      if(VRy < 1.0/3.0) Gore(X,Y);
      else if(VRy > 2.0/3.0) Dolje(X,Y);
      
      cursor(x1,y1);
      
  }
}