#include "mbed.h"
#include "N5110.h"

#define POLUPRECNIK 5

N5110 display (dp4, dp24, dp23, dp25, dp2, dp6, dp18);
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);
InterruptIn SW(dp9);
DigitalOut enable(dp14);
Timer deb;

bool tabela = false;
bool player1 = true;
bool nerjeseno = false;

int pobjedeX;
int pobjedeO;
int brojac;

struct kursor {
    int x;
    int y;
} _c;

struct polje {
    kursor gore_lijevo;
    kursor dolje_desno;
    char vrijednost;
};

polje ekran[3][3];


void postaviPolja(){

ekran[0][0].gore_lijevo.x = 0;
ekran[0][0].gore_lijevo.y = 0;
ekran[0][0].dolje_desno.x = 26;
ekran[0][0].dolje_desno.y = 14;
ekran[0][0].vrijednost = 'a';

ekran[0][1].gore_lijevo.x = 0;
ekran[0][1].gore_lijevo.y = 16;
ekran[0][1].dolje_desno.x = 26;
ekran[0][1].dolje_desno.y = 30;
ekran[0][1].vrijednost = 'a';

ekran[0][2].gore_lijevo.x = 0;
ekran[0][2].gore_lijevo.y = 32;
ekran[0][2].dolje_desno.x = 26;
ekran[0][2].dolje_desno.y = 47;
ekran[0][2].vrijednost = 'a';

ekran[1][0].gore_lijevo.x = 28;
ekran[1][0].gore_lijevo.y = 0;
ekran[1][0].dolje_desno.x = 54;
ekran[1][0].dolje_desno.y = 14;
ekran[1][0].vrijednost = 'a';

ekran[1][1].gore_lijevo.x = 28;
ekran[1][1].gore_lijevo.y = 16;
ekran[1][1].dolje_desno.x = 54;
ekran[1][1].dolje_desno.y = 30;
ekran[1][1].vrijednost = 'a';

ekran[1][2].gore_lijevo.x = 28;
ekran[1][2].gore_lijevo.y = 32;
ekran[1][2].dolje_desno.x = 54;
ekran[1][2].dolje_desno.y = 47;
ekran[1][2].vrijednost = 'a';

ekran[2][0].gore_lijevo.x = 56;
ekran[2][0].gore_lijevo.y = 0;
ekran[2][0].dolje_desno.x = 83;
ekran[2][0].dolje_desno.y = 14;
ekran[2][0].vrijednost = 'a';

ekran[2][1].gore_lijevo.x = 56;
ekran[2][1].gore_lijevo.y = 16;
ekran[2][1].dolje_desno.x = 83;
ekran[2][1].dolje_desno.y = 30;
ekran[2][1].vrijednost = 'a';

ekran[2][2].gore_lijevo.x = 56;
ekran[2][2].gore_lijevo.y = 32;
ekran[2][2].dolje_desno.x = 83;
ekran[2][2].dolje_desno.y = 47;
ekran[2][2].vrijednost = 'a';
}

int mod; //0 - pocetni; 1 - singleplayer; 2 - multiplayer
int player;
int polja[3][3];

void cursor(int x, int y)
{
    display.setPixel(x, y+1);
    display.setPixel(x-1, y);
    display.setPixel(x, y);
    display.setPixel(x+1, y);
    display.setPixel(x, y-1);
    display.refresh();
}

void drawTable();
void osvjezi();

void brisi(int x, int y)
{
    display.clearPixel(x, y+1);
    display.clearPixel(x-1, y);
    display.clearPixel(x, y);
    display.clearPixel(x+1, y);
    display.clearPixel(x, y-1);
    display.refresh();
    if(tabela) {
        drawTable();
        osvjezi();
    }
}

void Lijevo(int &x, int &y)
{
    if(x>1){
        brisi(x,y);
        x=x-1;
        cursor(x,y);
        
    }
}
 
void Desno(int &x, int &y)
{
    if(x<82){
        brisi(x,y);
        x=x+1;
        cursor(x,y);
    }
}
 
void Gore(int &x, int &y)
{
    if(y>1){
        brisi(x,y);
        y=y-1;
        cursor(x,y);
    }
}
 
void Dolje(int &x, int &y)
{
    if(y<46){
        brisi(x,y);
        y=y+1;
        cursor(x,y);
    }
}

void tekst();

void inicijalizirajDisplej(){
    tekst();
}

void tekst() {
    display.setXYAddress(0, 0);
    display.printChar('I');
    display.printChar('z');
    display.printChar('a');
    display.printChar('b');
    display.printChar('e');
    display.printChar('r');
    display.printChar('i');
    display.printChar('t');
    display.printChar('e');
    display.printChar(' ');
    display.printChar('m');
    display.printChar('o');
    display.printChar('d');
    display.printChar(':');
    display.setXYAddress(0, 2);
    display.printChar('1');
    display.printChar(' ');
    display.printChar('i');
    display.printChar('g');
    display.printChar('r');
    display.printChar('a');
    display.printChar('c');
    display.setXYAddress(0, 4);
    display.printChar('2');
    display.printChar(' ');
    display.printChar('i');
    display.printChar('g');
    display.printChar('r');
    display.printChar('a');
    display.printChar('c');
    display.printChar('a');
    
}

void drawTable() {
    for(int i = 0; i < 84; i++) {
        display.setPixel(i, 15);
        display.setPixel(i, 31);
    }
    for(int i = 0; i < 48; i++) {
        display.setPixel(27, i);
        display.setPixel(55, i);
    }
    display.refresh();
}

void singleplayerMod(){
    display.clear();
    mod = 1;
    tabela = true;
    drawTable();
}

void multiplayerMod(){
    display.clear();
    tabela = true;
    drawTable();
    mod = 2;
}

void izbor (){
    if(_c.y >= 8*2 && _c.y <= 8*3) {singleplayerMod();}
    else if(_c.y >= 8*4 && _c.y <= 8*5) {multiplayerMod();}
}

void krajIgre() {
    display.clear();
    display.printChar('R');
    display.printChar('e');
    display.printChar('z');
    display.printChar('u');
    display.printChar('l');
    display.printChar('t');
    display.printChar('a');
    display.printChar('t');
    display.printChar(':');
    display.printChar(' ');
    display.printChar('0' + pobjedeX);
    display.printChar('-');
    display.printChar('0' + pobjedeO);
    wait(3);
    display.clear();
    drawTable();
    for(int i = 0; i < 3; i++) {
        for(int j = 0; j < 3;  j++) {
            ekran[i][j].vrijednost = 'a';
        }
    }
    brojac = 0;
}

void provjeriPobjede() {
    if(
    (ekran[0][0].vrijednost == ekran[0][1].vrijednost && ekran[0][1].vrijednost == ekran[0][2].vrijednost && ekran[0][2].vrijednost != 'a') ||
    (ekran[1][0].vrijednost == ekran[1][1].vrijednost && ekran[1][1].vrijednost == ekran[1][2].vrijednost && ekran[1][2].vrijednost != 'a') ||
    (ekran[2][0].vrijednost == ekran[2][1].vrijednost && ekran[2][1].vrijednost == ekran[2][2].vrijednost && ekran[2][2].vrijednost != 'a') ||
    (ekran[0][0].vrijednost == ekran[1][0].vrijednost && ekran[1][0].vrijednost == ekran[2][0].vrijednost && ekran[2][0].vrijednost != 'a') ||
    (ekran[0][1].vrijednost == ekran[1][1].vrijednost && ekran[1][1].vrijednost == ekran[2][1].vrijednost && ekran[2][1].vrijednost != 'a') ||
    (ekran[0][2].vrijednost == ekran[1][2].vrijednost && ekran[1][2].vrijednost == ekran[2][2].vrijednost && ekran[2][2].vrijednost != 'a') ||
    (ekran[0][0].vrijednost == ekran[1][1].vrijednost && ekran[1][1].vrijednost == ekran[2][2].vrijednost && ekran[2][2].vrijednost != 'a') ||
    (ekran[0][2].vrijednost == ekran[1][1].vrijednost && ekran[1][1].vrijednost == ekran[2][0].vrijednost && ekran[2][0].vrijednost != 'a')
    ) {
        if(player1) {
            pobjedeX++;
            wait(1);
            krajIgre();
        }
        else {
            pobjedeO++;
            wait(1);
            krajIgre();
        }
    }
}

void crtajX(int x, int y);
void crtajO(int x0, int y0, int radius);

void klik() {
    if(deb.read_ms() > 400) {
        if(mod == 0) izbor();
        else {
            for(int i = 0; i < 3; i++) {
                for(int j = 0; j < 3; j++) {
                    if(_c.x >= ekran[i][j].gore_lijevo.x &&_c.x <= ekran[i][j].dolje_desno.x && _c.y >= ekran[i][j].gore_lijevo.y && _c.y <= ekran[i][j].dolje_desno.y && ekran[i][j].vrijednost == 'a') {
                        if(player1) {
                            crtajX(13+28*i, 7+16*j); 
                            ekran[i][j].vrijednost = 'X';
                            provjeriPobjede();
                            brojac++;
                        } 
                        else {
                            crtajO(13+28*i, 7+16*j, POLUPRECNIK);
                            ekran[i][j].vrijednost = 'O';
                            provjeriPobjede();
                            brojac++;
                        }
                        player1 = !player1;
                        if(mod == 1) {
                            for(int a = 0; a < 3; a++) {
                                for(int b = 0; b < 3; b++) {
                                    if(ekran[a][b].vrijednost == 'a' && !player1) {
                                        crtajO(13+28*a, 7+16*b, POLUPRECNIK);
                                        ekran[a][b].vrijednost = 'O';
                                        provjeriPobjede();
                                        player1 = !player1;
                                        brojac++;
                                    }
                                }
                            }
                        }
                        if(brojac == 9) {
                            wait(1);
                            krajIgre();
                        }
                    }
                }
            }
        }
        deb.reset();
    }
}

void crtajX(int x, int y) {
    display.setPixel(x, y);
    for(int i = 1; i <= 5; i++) {
        display.setPixel(x+i, y+i);
        display.setPixel(x+i, y-i);
        display.setPixel(x-i, y+i);
        display.setPixel(x-i, y-i);
    }
    display.refresh();
}

void crtajO(int x0, int y0, int radius) {
    int x = radius, y = 0;
    int radiusError = 1-x;
 
    while(x >= y)
    {
        display.setPixel(x + x0, y + y0);
        display.setPixel(y + x0, x + y0);
        display.setPixel(-x + x0, y + y0);
        display.setPixel(-y + x0, x + y0);
        display.setPixel(-x + x0, -y + y0);
        display.setPixel(-y + x0, -x + y0);
        display.setPixel(x + x0, -y + y0);
        display.setPixel(y + x0, -x + y0);
        y++;
        if (radiusError<0)
        {
            radiusError += 2 * y + 1;
        } else {
            x--;
            radiusError+= 2 * (y - x + 1);
        }
    }
    display.refresh();
}

void osvjezi() {
    for(int i = 0; i < 3; i++) {
        for(int j = 0; j < 3; j++) {
            if(ekran[i][j].vrijednost == 'X') {
                crtajX(13+28*i, 7+16*j);
            }
            else if(ekran[i][j].vrijednost == 'O') {
                crtajO(13+28*i, 7+16*j, POLUPRECNIK);
            }
        }
    }
}

int main() {
    enable = 1;
    SW.mode(PullUp);
    pobjedeX = 0;
    pobjedeO = 0;
    _c.x = 1;
    _c.y = 1;
    mod = 0;
    display.init();
    SW.rise(&klik);
    deb.start();
    inicijalizirajDisplej();
    postaviPolja();
    while(1) {
        if(mod == 0) tekst();
        if(VRx < 1.0/3.0) Lijevo(_c.x, _c.y);
        else if(VRx > 2.0/3.0) Desno(_c.x, _c.y);
        if(VRy < 1.0/3.0) Gore(_c.x, _c.y);
        else if(VRy > 2.0/3.0) Dolje(_c.x, _c.y);
    }
}