#include "mbed.h"
#include "TSISensor.h"
 
PwmOut red(LED_RED);
PwmOut green(LED_GREEN);
PwmOut blue(LED_BLUE);
 
Serial pc(USBTX, USBRX);
TSISensor senzor;
 
Ticker tick;
 
void ispisi()
{
    pc.printf("Senzor: %g %\n", senzor.readPercentage()*100);
 
}

void Ukljuci(char c, float i) {
    
    if(c == 'R') red = i;
    else if(c == 'G') green = i;
    else if(c == 'B') blue = i;
    else return;
}
 
int main()
{
    red = 1;
    green = 1;
    blue = 1;  
 
    while(1)
    {
        char znak = pc.getc();
        if(znak == 'P') tick.attach(&ispisi, 1);
        else if(znak=='Z') tick.detach();
        else 
        {
            int p=(pc.getc() - '0') * 10;
            int d=pc.getc() - '0';
            red = green = blue = 1;
            float intenzitet=(p+d)/100.;
            Ukljuci(znak,intenzitet);
        }
    }
}