#include "mbed.h"
#include "N5110.h"
#include <stdlib.h>
#include <stdio.h>
#include <sstream>

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);


Timer stoperica;
Ticker t;
Timer speedy;
bool isAttached;
int difficulty;
int whatIsWorkingFlag; // Menu-0,Difficulty-1,HighScores-2,Game-3
int highScores[3] = {0,0,0};
int score;
double speed;
int asteroid1[3] = {0,0,0};
int asteroid2[3] = {0,0,0};
int asteroid3[3] = {0,0,0};
int asteroid4[3] = {0,0,0};
int asteroid5[3] = {0,0,0};
int asteroid6[3] = {0,0,0};
int player[3] = {0,0,0};


void setAsteroids(void);
void startAsteroids(void);
void updateHighScores(void);
void resetHighScores(void);
void startGame(void);
void paintDifficulty(void);
void paintHighScores(void);
void paintScore(void);
void callPlayer(void);

char* convertToChar(int n)
{
    static char k[10];
    int temp=n;
    int broj=0;
    while (temp)
    {
        temp/=10;
        broj++;
    }
    broj--;
    while (n)
    {
        temp=n%10;
        n/=10;
        k[broj]=temp+'0';
        broj--;
    }
    return k;
}

void updateHighScores()
{
    if (score>highScores[0])
    {
        double temp = highScores[0];
        highScores[2] = highScores[1];
        highScores[1]=temp;
        highScores[0]=score;
    }
    else if (score>highScores[1])
    {
        highScores[2] = highScores[1];
        highScores[1]=score;
    }
    else if (score>highScores[2]) highScores[2] = score;
}

void resetHighScores()
{
    highScores[0]=0;
    highScores[1]=0;
    highScores[2]=0;
    whatIsWorkingFlag = 0;
}

void paintGameOverScore(){
    speedy.start();
    while(speedy.read()<1){
    char * c = convertToChar(score);
    lcd.printString("Game Over",0,0);
    lcd.printString("Score:",0,1);
    lcd.printString(c,0,2);  
} 
    for(int i = 0; i <3 ; i++){
        asteroid1[i]=0;
        asteroid2[i]=0;
        asteroid3[i]=0;
        asteroid4[i]=0;
        asteroid5[i]=0;
        asteroid6[i]=0;
        }                   
updateHighScores();score=0;
}
void gameOverTestA1(int ax,int ay)
{
    int px = player[0];
    int py = player[1];
    int playax[13]= {px,px-1,px,px+1,px-2,px-1,px+1,px+2,px-2,px+2,-1,-1,-1};
    int playay[13]= {py,py+1,py+1,py+1,py+2,py+2,py+2,py+2,py+3,py+3,-1,-1,-1};
    int asterx[13]= {ax,ax-1,ax,ax+1,ax-1,ax,ax+1,ax-2,ax-1,ax,ax+1,ax-1,ax};
    int astery[13]= {ay,ay+1,ay+1,ay+1,ay+2,ay+2,ay+2,ay+3,ay+3,ay+3,ay+3,ay+4,ay+4};

    for(int i=0; i<13; i++)
    {
        for(int j=0; j<13; j++)
        {
            if(playax[i]==asterx[j])
            {
                if(playay[i]==astery[j]){
                     lcd.clear();
                    whatIsWorkingFlag=0;
                    paintGameOverScore();
                    stoperica.reset();
                    stoperica.stop();
                    isAttached=false;
                break;}
            }
        }
    }



} //Implementacija Collision Testa
void gameOverTestA2(int ax,int ay)
{
    int px = player[0];
    int py = player[1];
    int playax[15]= {px,px-1,px,px+1,px-2,px-1,px+1,px+2,px-2,px+2,-1,-1,-1,-1,-1};
    int playay[15]= {py,py+1,py+1,py+1,py+2,py+2,py+2,py+2,py+3,py+3,-1,-1,-1,-1,-1};
    int asterx[15]= {ax-2,ax-1,ax,ax-1,ax,ax+1,ax-2,ax-1,ax,ax-1,ax,ax-2,ax-1,ax,ax+1};
    int astery[15]= {ay,ay,ay,ay+1,ay+1,ay+1,ay+2,ay+2,ay+2,ay+3,ay+3,ay+4,ay+4,ay+4,ay+4};
    for(int i=0; i<15; i++)
    {
        for(int j=0; j<15; j++)
        {
            if(playax[i]==asterx[j])
            {
                if(playay[i]==astery[j]){
                lcd.clear();
                    whatIsWorkingFlag=0;
                    paintGameOverScore();
                    stoperica.reset();
                    stoperica.stop();
                    isAttached=false;
                break;}
            }

        }
    }

} //Implementacija Collision Testa
void gameOverTestA3(int ax,int ay)
{
    int px = player[0];
    int py = player[1];
    int playax[18]= {px,px-1,px,px+1,px-2,px-1,px+1,px+2,px-2,px+2,-1,-1,-1,-1,-1,-1,-1,-1};
    int playay[18]= {py,py+1,py+1,py+1,py+2,py+2,py+2,py+2,py+3,py+3,-1,-1,-1,-1,-1,-1,-1,-1};
    int asterx[18]= {ax,ax+1,ax+2,ax+3,ax+4,ax+5,ax+6,ax+7,ax+1,ax+2,ax+3,ax+4,ax+5,ax+6,ax+7,ax+3,ax+4,ax+5};
    int astery[18]= {ay,ay,ay,ay,ay,ay,ay,ay,ay+1,ay+1,ay+1,ay+1,ay+1,ay+1,ay+1,ay+2,ay+2,ay+2};


    for(int i=0; i<18; i++)
    {
        for(int j=0; j<18; j++)
        {
            if(playax[i]==asterx[j])
            {
                if(playay[i]==astery[j]){
                lcd.clear();
                    whatIsWorkingFlag=0;
                    paintGameOverScore();
                    stoperica.reset();
                    stoperica.stop();
                    isAttached=false;
                break;}
            }

        }
    }

} //Implementacija Collision Testa


void AsteroidBody1(int asteroid[])
{


    int a=asteroid[0];
    int b=asteroid[1];
    int c=asteroid[2];
    for(int i=0; i<=4; i++)
        lcd.setPixel(a,b+i);

    for(int i=1; i<=4; i++)
        lcd.setPixel(a-1,b+i);

    for(int i=1; i<=3; i++)
        lcd.setPixel(a+1,b+i);

    lcd.setPixel(a-2,b+3);
    lcd.refresh();
    asteroid[1]=b;
    asteroid[0]=a;
    asteroid[2]=c;
    gameOverTestA1(a,b);

}

void AsteroidBody2(int asteroid[])
{

    int a=asteroid[0];
    int b=asteroid[1];
    int c=asteroid[2];
    for(int i=0; i<=4; i++)
        lcd.setPixel(a,b+i);

    for(int i=0; i<=4; i++)
        lcd.setPixel(a-1,b+i);

    for(int i=0; i<=4; i=i+2)
        lcd.setPixel(a-2,b+i);

    lcd.setPixel(a+1,b+1);
    lcd.setPixel(a+1,b+4);
    lcd.refresh();
    asteroid[1]=b;
    asteroid[0]=a;
    asteroid[2]=c;
    gameOverTestA2(a,b);

}

void AsteroidBody3(int asteroid[])
{

    int a=asteroid[0];
    int b=asteroid[1];
    int c=asteroid[2];
    lcd.setPixel(a,b);
    for(int i=1; i<=7; i++)
    {
        lcd.setPixel(a+i,b);
        lcd.setPixel(a+i,b+1);
    }
    for(int i=3; i<=5; i++)
        lcd.setPixel(a+i,b+2);

    lcd.refresh();
    asteroid[1]=b;
    asteroid[0]=a;
    asteroid[2]=c;
    gameOverTestA3(a,b);

}

void paintMenu()
{
    if(!whatIsWorkingFlag){
    int y = player[1];
    lcd.printString("Start Game",0,0);
    lcd.printString("Set Difficulty",0,1);
    lcd.printString("HighScores",0,2);
    lcd.printString("RstHighScores",0,3);
    if(SW==0&&y>=0&&y<=7)
    {
        whatIsWorkingFlag = 3;player[0]=42;player[1]=43;
        startGame();
    }
    else if(SW==0&&y>=8&&y<=15)
    {
        whatIsWorkingFlag=1;
        paintDifficulty();
    }
    else if(SW==0&&y>=16&&y<=23)
    {
        whatIsWorkingFlag=2;
        paintHighScores();
    }
    else if(SW==0&&y>=24&&y<=40)
    {
        whatIsWorkingFlag=0;
        resetHighScores();
    }
}
else{
if(whatIsWorkingFlag==1){paintDifficulty();}
else if(whatIsWorkingFlag==2){paintHighScores();}
else if(whatIsWorkingFlag==3){startGame();}
}
}

void paintDifficulty()
{
    int y= player[1];
    lcd.printString("Easy",0,0);
    lcd.printString("Normal",0,1);
    lcd.printString("Hard",0,2);
    if(!SW)
    {
        if(y>=0&&y<=7) {difficulty=0; speed=0.9;}
        else if(y>=8&&y<=15) {difficulty=1;speed=0.85;}
        else if(y>=16&&y<=23) {difficulty=2;speed=0.8;}
        whatIsWorkingFlag=0;
        paintMenu();
    }
}

void paintHighScores()
{
    wait(0.02);
    while(SW){
    char *s1;
    char *s2;
    char *s3;
        s1=convertToChar(highScores[0]);
        s2=convertToChar(highScores[1]);
        s3=convertToChar(highScores[2]);

    lcd.printString("R1:",0,0);
    lcd.printString(s1,6,0);
    lcd.printString("R2:",0,1);
    lcd.printString(s2,6,1);
    lcd.printString("R3:",0,2);
    lcd.printString(s3,6,2);}
    whatIsWorkingFlag = 0;
}

void paintScore()
{
    int xyz;
    if (difficulty==0) xyz=2;
    else if(difficulty==1) xyz=4;
    else xyz=6;
    double speed1 = 1.0-speed;
    score = (int)((speed1*stoperica.read_ms()*xyz)/10);
    char * s= convertToChar(score);
    lcd.printString(s,0,5);
}





void startGame()
{
    if(!isAttached)
    {
        isAttached=!isAttached;
        stoperica.start();
    }
    int xyz=stoperica.read();
    if (xyz%3==0){
    if (speed>0.2)
    {if(difficulty==0)
    
    { speed = speed - 0.02;}
    else if(difficulty == 1){speed = speed - 0.05;}
    else {speed = speed - 0.1;}
    }}
    setAsteroids();

}


void PlayerBody(int a,int b)
{
    if(a<3 || a>81 || b<3 || b>45) return;
    lcd.clear();
    lcd.setPixel(a,b);
    lcd.setPixel(a,b+1);
    lcd.setPixel(a-1,b+1);
    lcd.setPixel(a+1,b+1);
    lcd.setPixel(a-1,b+2);
    lcd.setPixel(a+1,b+2);
    lcd.setPixel(a-2,b+2);
    lcd.setPixel(a+2,b+2);
    lcd.setPixel(a-2,b+3);
    lcd.setPixel(a+2,b+3);
    lcd.refresh();
    player[0]=a;
    player[1]=b;
    player[2]=1;

}
void callPlayer()
{
    int x= player[0];
    int y = player[1];
    if (VRx<1.0/3.0)
    {
        x=x-1;

        PlayerBody(x,y);
    }
    else if (VRx<2.0/3.0)
    {
        PlayerBody(x,y);
    }
    else
    {
        x=x+1;
        PlayerBody(x,y);
    }
    
     if (VRy<1.0/3.0)
    {
        y=y-1;

        PlayerBody(x,y);
    }
    else if (VRy<2.0/3.0)
    {
        PlayerBody(x,y);
    }
    else
    {
        y=y+1;
        PlayerBody(x,y);
    }
}

int postojiLiAsteroid()
{
    int n=0;
    if(asteroid6[2]) n++;
    if(asteroid5[2]) n++;
    if(asteroid4[2]) n++;
    if(asteroid3[2]) n++;
    if(asteroid2[2]) n++;
    if(asteroid1[2]) n++;
    return n;
}

void setAsteroids()
{
    int n=postojiLiAsteroid();
    if(!n)
    {
        int i = rand()%3+1;
        asteroid1[2]=i;
        goto nastavak;
    }

    else
    {
        if(n==2&&difficulty==0) goto nastavak;
        if(n==4&&difficulty==1) goto nastavak;
        if(n==6&&difficulty==2) goto nastavak;

        int i = rand()%3+1;
    int j = rand()%4+1;
    if(j>2){
    if (!asteroid1[2])asteroid1[2]=i;
    else if (!asteroid2[2]) asteroid2[2]=i;
    else if (!asteroid3[2]) asteroid3[2]=i;
    else if (!asteroid4[2])asteroid4[2]=i;
    else if (!asteroid5[2]) asteroid5[2]=i;
    else if (!asteroid6[2])asteroid6[2]=i;
    }
    goto nastavak;
    }
nastavak:
    {
        startAsteroids();
    }

}
void updateAsteroids(int asteroid[]){
    int b = asteroid[1];
        b++;
    if(b>48)
    {
        b=0;
        asteroid[0]=0;
        asteroid[2]=0;
    }
    asteroid[1]=b;
    
    }
    
    void updateAsteroidCall(){
        if(asteroid1[2])
    {
            updateAsteroids(asteroid1);
    }
    if(asteroid2[2])
    {
            updateAsteroids(asteroid2);

    }
    if(asteroid3[2])
    {
         updateAsteroids(asteroid3);
    }
    if(asteroid4[2])
    {
         updateAsteroids(asteroid4);
    }
    if(asteroid5[2])
    {
        updateAsteroids(asteroid5);
    }
    if(asteroid6[2])
    {
        updateAsteroids(asteroid6);
    }
        
        }
void startAsteroids()
{
    speedy.start();
    while(speedy.read()<speed){
    if(asteroid1[2])
    {
        if(asteroid1[0]==0&&asteroid1[1]==0)
        {
            int k = rand()%83;
            asteroid1[0]=k;
        }
        int i=asteroid1[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid1);
            break;
        case 2:
            AsteroidBody2(asteroid1);
            break;
        case 3:
            AsteroidBody3(asteroid1);
            break;
        }
    }
    if(asteroid2[2])
    {
        if(asteroid2[0]==0&&asteroid2[1]==0)
        {
            int k = rand()%83;
            asteroid2[0]=k;
        }
        int i=asteroid2[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid2);
            break;
        case 2:
            AsteroidBody2(asteroid2);
            break;
        case 3:
            AsteroidBody3(asteroid2);
            break;
        }
    }
    if(asteroid3[2])
    {
        if(asteroid3[0]==0&&asteroid3[1]==0)
        {
            int k = rand()%83;
            asteroid3[0]=k;
        }
        int i=asteroid3[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid3);
            break;
        case 2:
            AsteroidBody2(asteroid3);
            break;
        case 3:
            AsteroidBody3(asteroid3);
            break;
        }
    }
    if(asteroid4[2])
    {
        if(asteroid4[0]==0&&asteroid4[1]==0)
        {
            int k = rand()%83;
            asteroid4[0]=k;
        }
        int i=asteroid4[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid4);
            break;
        case 2:
            AsteroidBody2(asteroid4);
            break;
        case 3:
            AsteroidBody3(asteroid4);
            break;
        }
    }
    if(asteroid5[2])
    {
        if(asteroid5[0]==0&&asteroid5[1]==0)
        {
            int k = rand()%83;
            asteroid5[0]=k;
        }
        int i=asteroid5[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid5);
            break;
        case 2:
            AsteroidBody2(asteroid5);
            break;
        case 3:
            AsteroidBody3(asteroid5);
            break;
        }
    }
    if(asteroid6[2])
    {
        if(asteroid6[0]==0&&asteroid6[1]==0)
        {
            int k = rand()%83;
            asteroid6[0]=k;
        }
        int i=asteroid6[2];

        switch (i)
        {
        case 1:
            AsteroidBody1(asteroid6);
            break;
        case 2:
            AsteroidBody2(asteroid6);
            break;
        case 3:
            AsteroidBody3(asteroid6);
            break;
        }
    }
        paintScore();
    }
    speedy.reset();speedy.stop();
    updateAsteroidCall();
}

int main()
{
    enable = 1;
    difficulty = 1;
    isAttached = false;
    whatIsWorkingFlag = 0;
    speed = 0.9;
    score = 0;

    //Aktivacija pull-up otpornika
    SW.mode(PullUp);
    lcd.init();
    lcd.setXYAddress(0,0);
    PlayerBody(42,43);
    t.attach(&callPlayer,0.1);
    while(1)
    {
        switch(whatIsWorkingFlag)
        {
        case 0:
            paintMenu();
            break;
        case 1:
            paintDifficulty();
            break;
        case 2:
            paintHighScores();
            break;
        case 3:
            startGame();
            break;
        }
    }
}
