#include "mbed.h"
#include "N5110.h"

AnalogIn VRx(dp11);
AnalogIn VRy(dp10);

N5110 display(dp4, dp24, dp23, dp25, dp2, dp6, dp18);

Timer timer1;
Timer timer2;

InterruptIn taster1(dp1);
DigitalOut enable(dp14);

bool klik = true;

int x = 42;
int y = 24;

int t1[2];
int t2[2];
int t3[2];
int t4[2];

bool temp1 = false;
bool temp2 = false;
bool temp3 = false;
bool temp4 = false;

void ocitajXY()
{
    if (VRx < 1.0/3.0)
    {
        x--;
        if(x < 0) x = 0;
    }
    
    if (VRx > 2.0/3.0)
    {
        x++;
        if(x > 83) x = 83;
    }
    
    if (VRy < 1.0/3.0)
    {
        y--;
        if(y < 0) y = 0;
    }
    
    if (VRy > 2.0/3.0)
    {
        y++;
        if(y > 47) y = 47;
    }
    
    t1[0] = x - 1;
    t1[1] = y;
    
    t2[0] = x;
    t2[1] = y + 1;
    
    t3[0] = x + 1;
    t3[1] = y;
    
    t4[0] = x;
    t4[1] = y - 1;
}

void crtajTacku()
{
    /*
    if(timer1.read_ms() > 200 && timer1.read_ms() < 500)
    {
        timer1.reset();
        display.clear();
        x = 42;
        y = 24;
    }
    
    if(timer1.read_ms() > 200)
    {
        timer1.reset();
        display.setPixel(x, y);
        display.refresh();
    }
    */

    
    if(klik)
    {   
        if(timer1.read_ms() > 200)
        {
            klik = !klik;
            timer1.reset();
            display.setPixel(x, y);
            display.refresh();
        }
    }
    else
    {
        if(timer1.read_ms() > 200 && timer1.read_ms() < 1300)
        {
            timer1.reset();
            display.clear();
            x = 42;
            y = 24;
        }
        if(timer1.read_ms() > 1300)
        {
            timer1.reset();
            display.setPixel(x, y);
            display.refresh();
        }
        
        klik = !klik;
    }
}

void crtajCrosshair()
{
    if(x > 0)
    {
        if(display.getPixel(t1[0], t1[1]) != 0)
            temp1 = true;
        display.setPixel(t1[0], t1[1]);
    }
    
    if(x < 83)
    {
        if(display.getPixel(t3[0], t3[1]) != 0)
            temp3 = true;
        display.setPixel(t3[0], t3[1]);
    }
    
    if(y > 0)
    {
        if(display.getPixel(t2[0], t2[1]) != 0)
            temp2 = true;
        display.setPixel(t2[0], t2[1]);
    }
    
    if(y < 47)
    {
        if(display.getPixel(t4[0], t4[1]) != 0)
            temp4 = true;
        display.setPixel(t4[0], t4[1]);
    }
    
    display.refresh();
}

void brisiCrosshair()
{
    if(!temp1)
        display.clearPixel(t1[0], t1[1]);
    if(!temp2)
        display.clearPixel(t2[0], t2[1]);
    if(!temp3)
        display.clearPixel(t3[0], t3[1]);
    if(!temp4)
        display.clearPixel(t4[0], t4[1]);
    
    display.refresh();
    
    temp1 = false;
    temp2 = false;
    temp3 = false;
    temp4 = false;
}

void osvjezi()
{
    brisiCrosshair();
    ocitajXY();
    crtajCrosshair();
}

int main() {
    enable = 1;
    display.init();
    display.setXYAddress(0, 0);
    timer1.start();
    taster1.rise(&crtajTacku);
    while(1){
        wait(0.25);
        osvjezi();
    }
}
