#include "mbed.h"
#include "TSISensor.h"

PwmOut r(LED1);
PwmOut g(LED2);
PwmOut b(LED3);

Serial pc(USBTX, USBRX);

TSISensor tsi;
Ticker t1;

char buf[150];
int i = 0;

void ispisiTSI()
{
    pc.printf("\nTSI: %f", tsi.readPercentage());
}

void upaliLedicu(char ledica, float intenzitet)
{
    if(ledica == 'R')
    {
        r = 1.0 - intenzitet;
        g = 1.0;
        b = 1.0;
    }
    
    if(ledica == 'G')
    {
        r = 1.0;
        g = 1.0 - intenzitet;
        b = 1.0;
    }
    
    if(ledica == 'B')
    {
        r = 1.0;
        g = 1.0;
        b = 1.0 - intenzitet;
    }
}

void ocitaj()
{

    buf[i] = pc.getc();
    i++;

    
    if((buf[0] == 'R' or buf[0] == 'G' or buf[0] == 'B') and buf[1] >= '0' and buf[1] <= '9' and buf[2] >= '0' and buf[2] <= '9' and i == 3)
    {
        char ledica = buf[0];
        float intenzitet = ((buf[1] - 48)*10 + buf[2] - 48)/100.0;
        upaliLedicu(ledica, intenzitet);
        i = 0;
    }
    
    if(buf[0] == 'P' and i == 1)
    {
        i = 0;
        t1.attach(&ispisiTSI, 1);
    }
    
    if(buf[0] == 'Z' and i == 1)
    {
        i = 0;
        t1.detach();
    }
}

int main() {
    r = 1.0;
    g = 1.0;
    b = 1.0;  
    pc.attach(&ocitaj);
}
