#include "mbed.h"
#include "sMotor.h"

Serial pc(USBTX, USBRX);
sMotor motor(dp13, dp11, dp10, dp9);

int step_speed = 0;
int numstep = 512;
int direction = 0;
int main() {
    pc.printf("O - Postavljanje osovine u proizvoljan polozaj. \n");
    pc.printf("P - Promjena smjera okretanja. \n");
    pc.printf("B - Promjena brzine okretanja. \n");
    pc.printf("K - Pokreni motor. \n");
    pc.printf("S - Zustavi motor. \n");
    pc.printf("Trenutna brzina je %d", step_speed);
    step_speed=1200;
    while(1) {
        if(pc.readable()) 
        {
            char a = pc.getc();
        if(a=='O')
        {
            int ugao;
            pc.printf("\nUnesi ugao: ");
            pc.scanf("%d", &ugao);
            numstep = (ugao/360.00)*512;
            motor.step(numstep,direction,step_speed);
        }
        if(a=='P')
        {
            numstep = 512;
            if(direction==0)
            {
            motor.anticlockwise();
            direction = 1;
            }
            else
            {
                motor.clockwise();
                direction = 0;
            }
            motor.step(numstep,direction,step_speed);
        }
        if(a=='B')
        {
            pc.printf("Trenutna brzina je %d, unesite novu: ");
            pc.scanf("%d", &step_speed);
            motor.step(numstep,direction,step_speed);
        }
        if(a=='K')
        {   
            if(step_speed==0)
            step_speed = 1200;
            motor.step(numstep,direction,step_speed);
        }
        if(a=='S')
        {
            motor.step(0,direction,step_speed);
        }
    }
}
}
