#include "mbed.h"
#include "MatrixSPI.h"
#include <string>

#ifndef DOTMATRIX_H
#define DOTMATRIX_H

enum ModPrikazivanja{scroll, char_by_char, live_input};
const char znakovi[66][6] =
{
    {0, 0x7e, 0x11, 0x11, 0x7e, 0},//A
    {0, 0x7e, 0x49, 0x49, 0x36, 0}, //B
    {0, 0x3e, 0x41, 0x41, 0x22, 0}, //C
    {0, 0x7f, 0x41, 0x41, 0x3e, 0}, //D
    {0, 0x7f, 0x49, 0x49, 0x41, 0}, //E
    {0, 0x7f, 0x09, 0x09, 0x01, 0}, //F
    {0x3e, 0x41, 0x51, 0x32, 0x70, 0}, //G
    {0, 0x7f, 0x08, 0x08, 0x7f, 0}, //H
    {0, 0x41, 0x7f, 0x41, 0, 0}, //I
    {0, 0x21, 0x41, 0x41, 0x3f, 0}, //J
    {0, 0x7f, 0x08, 0x14, 0x63, 0}, //K
    {0, 0x7f, 0x40, 0x40, 0x40, 0}, //L
    {0x7f, 0x02, 0x0c, 0x02, 0x7f, 0}, //M
    {0x7f, 0x04, 0x08, 0x10, 0x7f, 0}, //N
    {0, 0x3e, 0x41, 0x41, 0x3e, 0}, //O
    {0, 0x7f, 0x09, 0x09, 0x06, 0}, //P
    {0x3e, 0x41, 0x51, 0x3e, 0x40, 0}, //Q
    {0, 0x7f, 0x09, 0x09, 0x76, 0}, //R
    {0, 0x26, 0x89, 0x89, 0x32, 0}, //S
    {0x03, 0x01, 0x7f, 0x01, 0x03, 0},  //T
    {0x1f, 0x20, 0x40, 0x40, 0x20, 0x1f},  //U
    {0x1f, 0x20, 0x40, 0x20, 0x1f, 0}, //V
    {0x3f, 0x40, 0x38, 0x40, 0x3f, 0}, //W
    {0x63, 0x14, 0x08, 0x14, 0x63, 0}, //X
    {0x07, 0x08, 0x70, 0x08, 0x07, 0}, //Y
    {0x61, 0x51, 0x49, 0x45, 0x43, 0}, //Z
    {0, 0x20, 0x54, 0x54, 0x78, 0}, //a
    {0, 0x7f, 0x44, 0x44, 0x38, 0}, //b
    {0, 0x38, 0x44, 0x44, 0x28, 0}, //c
    {0, 0x38, 0x44, 0x44, 0x7f, 0}, //d
    {0, 0x38, 0x54, 0x54, 0x18, 0}, //e
    {0, 0xf8, 0x24, 0x24, 0x08, 0}, //f
    {0, 0x98, 0xa4, 0xa4, 0x78, 0}, //g
    {0, 0x7f, 0x04, 0x04, 0x78, 0}, //h
    {0, 0x44, 0x7d, 0x40, 0, 0}, //i
    {0, 0x40, 0x80, 0x88, 0x7a, 0}, //j
    {0, 0x7f, 0x10, 0x28, 0x44, 0}, //k
    {0, 0x41, 0x7f, 0x40, 0, 0}, //l
    {0x7c, 0x04, 0x7c, 0x04, 0x78, 0}, //m
    {0, 0x7c, 0x04, 0x04, 0x78, 0}, //n
    {0, 0x38, 0x44, 0x44, 0x38, 0}, //o
    {0, 0xfc, 0x24, 0x24, 0x18, 0}, //p
    {0, 0x18, 0x24, 0x24, 0xfc, 0}, //q
    {0, 0x7c, 0x08, 0x04, 0x04, 0}, //r
    {0, 0x48, 0x54, 0x54, 0x24, 0}, //s
    {0, 0x04, 0x3f, 0x44, 0, 0}, //t
    {0, 0x3c, 0x40, 0x40, 0x7c, 0}, //u
    {0x1c, 0x20, 0x40, 0x20, 0x1c, 0}, //v
    {0x1c, 0x20, 0x10, 0x20, 0x1c, 0}, //w
    {0x44, 0x28, 0x10, 0x28, 0x44, 0}, //x
    {0, 0x9c, 0xa0, 0xa0, 0x7c, 0}, //y
    {0x44, 0x64, 0x54, 0x4c, 0x44, 0}, //z
    {0x3e, 0x51, 0x49, 0x45, 0x3e, 0}, //0
    {0, 0x42, 0x7f, 0x40, 0, 0}, //1
    {0x42, 0x61, 0x51, 0x49, 0x46, 0}, //2
    {0, 0x22, 0x41, 0x49, 0x36, 0}, //3
    {0x08, 0x0c, 0x0a, 0x7c, 0x08, 0}, //4
    {0, 0x27, 0x45, 0x45, 0x39, 0}, //5
    {0, 0x3e, 0x49, 0x49, 0x32, 0}, //6
    {0x63, 0x11, 0x09, 0x05, 0x03, 0}, //7
    {0, 0x36, 0x49, 0x49, 0x36, 0}, //8
    {0, 0x26, 0x49, 0x49, 0x3e, 0}, //9
    {0, 0xb0, 0x70, 0, 0, 0}, //,
    {0, 0x60, 0x60, 0, 0, 0}, //.
    {0x10,0x27,0x40,0x40,0x27,0x10}, // :-)
    {0,0,0,0,0,0} // prazno
};

class DotMatrix{
    
public:
    DotMatrix(PinName data_input = dp2, PinName clock = dp6, PinName loadcs = dp24)
    :spi(data_input, clock, loadcs), turnedON(false), mod(scroll), char_trenutni(0),
    char_offset(0), repeat(true), brzina_ms(1000), isAttached(false)
    {    
        recenica = "Kokolo moje jedino.";  
        for(int i = 0; i < 8; i++) buffer[i] = 0;
    }
    
    void refresh();
    void setIntensity(float jacina);
    void setSpeed_ms(int ms);
    void turnON();
    void turnOFF();
    void PromijeniRecenicu(string recenica){
        this->recenica =  " " + recenica;
        char_trenutni = 0;
        char_offset = 0;
    }
    void NadodajNaRecenicu(char c){
        recenica += c;   
    }
    void NadodajNaRecenicu(string str){
        recenica += str;   
    }
    void PromijeniMod(ModPrikazivanja mod){
        if(this->mod != mod){
            this->mod = mod;
            attach();   
        }   
    }
    ModPrikazivanja dajMod() const{
        return mod;   
    }
    void SetRepeat(bool r){
     repeat = r;   
    }
    
    bool GetRepeat() const{
        return repeat;   
    }
    
    void setChar(char c, int offset)
    {
        int index;
        if(c >= 'A' && c <= 'Z')
            index = c - 'A';
        else if(c>= 'a' && c <='z')
            index = c - 'a' + 26;
        else if( c>= '0' && c <= '9')
            index = c - '0' + 52;
        else if (c== ',')
            index = 62;
        else if(c=='.')
            index = 63;
        else if(c==' ')
            index = 65;
        else
            index = 64;
        
        if(offset < 0)
        {
            for(int i = 0; i < 6 + offset; i++)
            {
                buffer[i] = znakovi[index][i - offset];   
            }  
        }   
        else 
        {
            for(int i = offset; i < 8 && i < 6 + offset; i++)
            {
                buffer[i] = znakovi[index][i - offset];   
            }
        }
    }
    
    void displaySingleChar(char c){
        setChar(c, 1);   
        refresh();
    }
    
      
    void prikaziScroll(){
        if(char_trenutni == recenica.size()) refresh();
        else {
            setChar(recenica[char_trenutni], char_offset);
            if(char_trenutni < recenica.size() - 1)
                setChar(recenica[char_trenutni + 1], char_offset + 7);
            
            if(char_offset < -6){
                char_offset = 1; // plus 7
                char_trenutni++;
            } 
        }
        
        if(char_trenutni >= recenica.size() && repeat)
            char_trenutni = 0;
        
    }
    void prikaziCBC(){
        if(char_trenutni == recenica.size()) refresh();
        else {//ako ne bude valjao refresh ne bude prazno prikazivali... skloniti else i dole >= u > promijeniti
            displaySingleChar(recenica[char_trenutni]);
            char_trenutni++;       
        }
        
         if(char_trenutni >= recenica.size() && repeat)
            char_trenutni = 0;  
    }
        
    int brzina_ms;    
    string recenica;
    int buffer[8];
    
private:
    void attach();
    void detach(){
        if(isAttached) ticker.detach();
        isAttached = false;   
    }
    
    
    MatrixSPI spi;
    bool turnedON;
    ModPrikazivanja mod;
    int char_trenutni, char_offset;
    Ticker ticker;
    bool isAttached; 
    bool repeat;
};



void DotMatrix::refresh(){
    for(int i = 0; i < 8; i++)
    {
        spi.sendCol(i, buffer[i]); 
        buffer[i] = 0;  
    }
}

void DotMatrix::setIntensity(float jacina){
    if(jacina <= 0){
        spi.turnOFF();
        turnedON = false;   
        
        
    } else if(jacina >= 0.98){
        if(!turnedON){ 
            spi.turnON();
            turnedON = true;
        }
        
        spi.sendSingle(MatrixSPI::intensity, 0x0f);
    } else {
        if(!turnedON){ 
            spi.turnON();
            turnedON = true;
        }
        
        int temp =  jacina*0x0f;
        spi.sendSingle(MatrixSPI::intensity, temp);
    } 
}

void DotMatrix::attach()
{
    detach();
    if(mod == scroll)
    {
        isAttached = true;
        ticker.attach(this, &DotMatrix::prikaziScroll, brzina_ms/8);
    } else if(mod == char_by_char){
        isAttached = true;
        ticker.attach(this, &DotMatrix::prikaziCBC, brzina_ms);
    }
}

void DotMatrix::setSpeed_ms(int ms)
{
    brzina_ms = ms;
    ticker.detach();
    attach();   
}

void DotMatrix::turnON(){
    if(!turnedON){
        spi.turnON();
        turnedON = true;
        
        attach();   
    }
}

void DotMatrix::turnOFF(){
    if(turnedON){
        spi.turnOFF();
        turnedON = false;
        
        ticker.detach();   
    }   
}

#endif //DotMatrix_h