#include "mbed.h"

#ifndef LEDMatrix_h
#define LEDMatrix_h


/*#include "LEDMatrix.h"

//DigitalOut myled(LED1);
AnalogIn pot(dp9);
Serial pc(USBTX, USBRX);

Ticker t;



// p5: DIN, p7: CLK, p8: LOAD/CS
SPI max72_spi(dp2, dp1, dp6);
DigitalOut load(dp24); //Chip_Select

int maxInUse = 1;    //change this variable to set how many MAX7219's you'll use

// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}

void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;

    for ( c = maxInUse; c > maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }

    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data

    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}


void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
}

void loop () {
    
    //if you use just one MAX7219 it should look like this
     maxSingle(1,0x1f);                       //  + - - - - - - -
     maxSingle(2,0x15);                       //  - + - - - - - -,,,,,,,,
     maxSingle(3,0x15);                       //  - - + - - - - -
     maxSingle(4,0x11);                       //  - - - + - - - -
     maxSingle(5,0xf0);                      //  - - - - + - - -
     maxSingle(6,0x80);                      //  - - - - - + - -
     maxSingle(7,0x80);                      //  - - - - - - + -
     maxSingle(8,0x80);                     //  - - - - - - - +

    
    //if you use more than one MAX7219, it should look like this

    /*
    maxAll(1,1);                       //  + - - - - - - -
    maxAll(2,3);                       //  + + - - - - - -
    maxAll(3,7);                       //  + + + - - - - -
    maxAll(4,15);                      //  + + + + - - - -
    maxAll(5,31);                      //  + + + + + - - -
    maxAll(6,63);                      //  + + + + + + - -
    maxAll(7,127);                     //  + + + + + + + -
    maxAll(8,255);                     //  + + + + + + + +
    */

    //

    //if you use more then one max7219 the second one should look like this


    /*
    maxOne(2,1,1);                       //  + - - - - - - -
    maxOne(2,2,2);                       //  - + - - - - - -
    maxOne(2,3,4);                       //  - - + - - - - -
    maxOne(2,4,8);                       //  - - - + - - - -
    maxOne(2,5,16);                      //  - - - - + - - -
    maxOne(2,6,32);                      //  - - - - - + - -
    maxOne(2,7,64);                      //  - - - - - - + -
    maxOne(2,8,128);                     //  - - - - - - - +

    
    
    //
    wait_ms(2000);

}*/
/*
class LEDMatrix7219{
    
public:
    
    LEDMatrix(PinName din, PinName clk, PinName load);
    
    void setIntensity(float intensity);
    void setMode
};*/
#endif